/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.internal.ContentTypeUtil;
import org.everit.osgi.webresource.internal.WebResourceContainerImpl;
import org.everit.osgi.webresource.internal.WebResourceImpl;
import org.everit.osgi.webresource.internal.WebResourceServlet;
import org.everit.osgi.webresource.internal.WebResourceServletPrototypeServiceFactory;
import org.everit.osgi.webresource.internal.WebResourceWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;

public class WebResourceExtender
implements BundleActivator {
    private BundleContext bundleContext;
    private ServiceRegistration<Servlet> pluginSR;
    private final WebResourceContainerImpl resourceContainer = new WebResourceContainerImpl();
    private ServiceRegistration<WebResourceContainer> resourceContainerSR;
    private ServiceRegistration<Servlet> servletFactorySR;
    private BundleTracker<Bundle> webResourceTracker;

    private void registerServletFactory() {
        WebResourceServletPrototypeServiceFactory webResourceServletFactory = new WebResourceServletPrototypeServiceFactory(this.resourceContainer);
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        ((Dictionary)serviceProps).put("service.description", "Everit WebResource Servlet");
        ((Dictionary)serviceProps).put("async-supported", true);
        this.servletFactorySR = this.bundleContext.registerService(new String[]{Servlet.class.getName(), WebResourceServlet.class.getName()}, (Object)webResourceServletFactory, serviceProps);
    }

    private void registerWebConsolePlugin() {
        WebResourceWebConsolePlugin webConsolePlugin = new WebResourceWebConsolePlugin(this.resourceContainer, this.resourceContainer);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("felix.webconsole.label", "everit-webresources");
        ((Dictionary)serviceProps).put("felix.webconsole.category", "Everit");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Webresources");
        ((Dictionary)serviceProps).put("service.description", "Everit WebResource WebConsole plugin");
        this.pluginSR = this.bundleContext.registerService(Servlet.class, (Object)webConsolePlugin, serviceProps);
    }

    private void registerWebResourceContainer() {
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Everit WebResource Container (read-only)");
        this.resourceContainerSR = this.bundleContext.registerService(WebResourceContainer.class, (Object)this.resourceContainer, serviceProps);
    }

    private String resolveFileName(URL resourceURL) {
        String externalForm = resourceURL.toExternalForm();
        int indexOfLastSlash = externalForm.lastIndexOf(47);
        if (indexOfLastSlash >= 0) {
            return externalForm.substring(indexOfLastSlash + 1);
        }
        return externalForm;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.registerWebResourceContainer();
        this.webResourceTracker = new WebResourceBundleTracker(context);
        this.webResourceTracker.open();
        this.registerServletFactory();
        this.registerWebConsolePlugin();
    }

    public void stop(BundleContext context) throws Exception {
        this.webResourceTracker.close();
        if (this.resourceContainerSR != null) {
            this.resourceContainerSR.unregister();
        }
        if (this.pluginSR != null) {
            this.pluginSR.unregister();
        }
        if (this.servletFactorySR != null) {
            this.servletFactorySR.unregister();
        }
    }

    private class WebResourceBundleTracker
    extends BundleTracker<Bundle> {
        WebResourceBundleTracker(BundleContext context) {
            super(context, 32, null);
        }

        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List capabilities = bundleWiring.getCapabilities("everit.webresource");
            boolean webResourceAdded = false;
            for (BundleCapability capability : capabilities) {
                Map attributes = capability.getAttributes();
                String libraryPrefix = this.resolveNormalizedLibraryPrefix(capability, attributes);
                String resourceFolder = (String)attributes.get("resourceFolder");
                Version version = this.resolveVersion(capability);
                if (resourceFolder == null) {
                    System.err.print("WARNING: Capability attribute resourceFolder is missing in bundle " + bundle.toString() + ": " + capability.toString());
                    continue;
                }
                Collection entries = bundleWiring.listResources(resourceFolder, "*", 1);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                for (String entry : entries) {
                    if (entry.endsWith("/")) continue;
                    URL resourceURL = classLoader.getResource(entry);
                    String fileName = WebResourceExtender.this.resolveFileName(resourceURL);
                    String library = entry.substring(resourceFolder.length(), entry.length() - fileName.length());
                    library = this.normalizeLibraryName(libraryPrefix, library);
                    String contentType = ContentTypeUtil.resolveContentType(resourceURL);
                    WebResourceImpl webResource = new WebResourceImpl(bundle, library, fileName, resourceURL, version, contentType);
                    WebResourceExtender.this.resourceContainer.addWebResource(webResource);
                    webResourceAdded = true;
                }
            }
            if (webResourceAdded) {
                return bundle;
            }
            return null;
        }

        private String normalizeLibraryName(String libraryPrefix, String library) {
            String result = library;
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            if ((result = result.startsWith("/") ? libraryPrefix + result : libraryPrefix + "/" + result).startsWith("/")) {
                result = result.substring(1);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
            WebResourceExtender.this.resourceContainer.removeBundle(bundle);
        }

        private String resolveNormalizedLibraryPrefix(BundleCapability capability, Map<String, Object> attributes) {
            String libraryPrefix = (String)attributes.get("libraryPrefix");
            if (libraryPrefix == null) {
                libraryPrefix = "";
            } else if (libraryPrefix.endsWith("/")) {
                System.err.print("WARNING: 'libraryPrefix' attribute of capability everit.webresource should not end with '/' character: " + capability.toString());
                libraryPrefix = libraryPrefix.substring(0, libraryPrefix.length() - 1);
            }
            return libraryPrefix;
        }

        private Version resolveVersion(BundleCapability capability) {
            Map attributes = capability.getAttributes();
            Object versionObject = attributes.get("version");
            if (versionObject == null) {
                return capability.getRevision().getBundle().getVersion();
            }
            if (versionObject instanceof Version) {
                return (Version)versionObject;
            }
            return new Version(versionObject.toString());
        }
    }
}

