/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.osgi.webresource.ContentEncoding;
import org.everit.osgi.webresource.WebResource;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.WebResourceURIGenerator;

public final class WebResourceUtil {
    private static final int BUFFER_SIZE = 1024;
    private static final int HTTP_NOT_MODIFIED = 304;

    private static boolean etagMatchFound(HttpServletRequest request, WebResource webResource) {
        String ifNoneMatchHeader = request.getHeader("If-None-Match");
        if (ifNoneMatchHeader == null) {
            return false;
        }
        String[] etags = ifNoneMatchHeader.split(",");
        int i = 0;
        int n = etags.length;
        boolean matchFound = false;
        while (!matchFound && i < n) {
            String etag = etags[i].trim();
            if (etag.equals('\"' + webResource.getETag() + '\"')) {
                matchFound = true;
                continue;
            }
            ++i;
        }
        return matchFound;
    }

    public static void findWebResourceAndWriteResponse(WebResourceContainer webResourceContainer, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String version;
        Optional<WebResource> optionalWebResource;
        int lastIndexOfSlash;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = req.getServletPath();
        }
        if ((lastIndexOfSlash = pathInfo.lastIndexOf(47)) == pathInfo.length() - 1) {
            WebResourceUtil.http404(resp);
            return;
        }
        String resourceName = pathInfo.substring(lastIndexOfSlash + 1);
        String lib = "";
        if (lastIndexOfSlash > 0) {
            lib = pathInfo.substring(1, lastIndexOfSlash);
        }
        if (!(optionalWebResource = webResourceContainer.findWebResource(lib, resourceName, Optional.ofNullable(version = req.getParameter("version")))).isPresent()) {
            WebResourceUtil.http404(resp);
            return;
        }
        WebResourceUtil.writeWebResourceToResponse(optionalWebResource.get(), req, resp);
    }

    public static Collection<WebResourceURIGenerator> getUriGeneratorsOfServletContext(ServletContext servletContext) {
        ConcurrentLinkedQueue uriGeneratorQueue = (ConcurrentLinkedQueue)servletContext.getAttribute(WebResourceURIGenerator.class.getName());
        if (uriGeneratorQueue == null) {
            uriGeneratorQueue = new ConcurrentLinkedQueue();
            servletContext.setAttribute(WebResourceURIGenerator.class.getName(), uriGeneratorQueue);
        }
        return uriGeneratorQueue;
    }

    private static void http404(HttpServletResponse resp) throws IOException {
        resp.sendError(404, "Resource cannot found");
    }

    private static ContentEncoding writeResponseHead(HttpServletRequest req, HttpServletResponse resp, WebResource webResource) {
        resp.setContentType(webResource.getContentType());
        resp.setHeader("Last-Modified", webResource.getLastModifiedRFC1123GMT());
        resp.setHeader("ETag", '\"' + webResource.getETag() + '\"');
        ContentEncoding contentEncoding = ContentEncoding.resolveEncoding(req);
        resp.setContentLength((int)webResource.getContentLength(contentEncoding));
        if (!ContentEncoding.RAW.equals((Object)contentEncoding)) {
            resp.setHeader("Content-Encoding", contentEncoding.getHeaderValue());
        }
        return contentEncoding;
    }

    private static void writeToOutputStreamFromInputStream(InputStream in, ServletOutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int r = in.read(buffer);
        while (r >= 0) {
            out.write(buffer, 0, r);
            r = in.read(buffer);
        }
    }

    public static void writeWebResourceToResponse(WebResource webResource, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Objects.requireNonNull(req);
        Objects.requireNonNull(resp);
        Objects.requireNonNull(webResource);
        ContentEncoding contentEncoding = WebResourceUtil.writeResponseHead(req, resp, webResource);
        if (WebResourceUtil.etagMatchFound(req, webResource)) {
            resp.setStatus(304);
            return;
        }
        if ("HEAD".equals(req.getMethod())) {
            return;
        }
        InputStream in = webResource.getInputStream(contentEncoding, 0);
        if (req.isAsyncSupported()) {
            AsyncContext async = req.startAsync();
            ServletOutputStream out = resp.getOutputStream();
            out.setWriteListener((WriteListener)new InputStreamBasedWriteListener(async, in));
        } else {
            ServletOutputStream out = resp.getOutputStream();
            WebResourceUtil.writeToOutputStreamFromInputStream(in, out);
        }
    }

    private WebResourceUtil() {
    }

    private static final class InputStreamBasedWriteListener
    implements WriteListener {
        private final AsyncContext async;
        byte[] buf = new byte[1024];
        private final InputStream in;

        private InputStreamBasedWriteListener(AsyncContext async, InputStream in) {
            this.in = in;
            this.async = async;
        }

        public void onError(Throwable t) {
            ServletContext servletContext = this.async.getRequest().getServletContext();
            if (servletContext != null) {
                servletContext.log("Async exception", t);
            } else {
                t.printStackTrace(System.err);
            }
            this.async.complete();
        }

        public void onWritePossible() throws IOException {
            ServletOutputStream out = this.async.getResponse().getOutputStream();
            while (out.isReady()) {
                int r = this.in.read(this.buf);
                if (r < 0) {
                    this.async.complete();
                    return;
                }
                out.write(this.buf, 0, r);
            }
        }
    }
}

