/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.everit.osgi.webresource.util.WebResourceUtil;

public final class ContentTypeUtil {
    private static final Properties DEFAULT_CONTENT_TYPES = new Properties();
    private static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";

    public static String resolveContentType(URL url) {
        String extension = url.toExternalForm();
        int lastIndexOfSlash = extension.lastIndexOf(47);
        if (lastIndexOfSlash > 0) {
            if (lastIndexOfSlash < extension.length() - 1) {
                extension = extension.substring(lastIndexOfSlash + 1);
            } else {
                return UNKNOWN_CONTENT_TYPE;
            }
        }
        int indexOfExtensionSeparator = extension.indexOf(46);
        String contentType = null;
        while (indexOfExtensionSeparator >= 0 && contentType == null) {
            if (indexOfExtensionSeparator == extension.length() - 1) {
                contentType = UNKNOWN_CONTENT_TYPE;
                continue;
            }
            contentType = DEFAULT_CONTENT_TYPES.getProperty(extension = extension.substring(indexOfExtensionSeparator + 1));
            if (contentType != null) continue;
            indexOfExtensionSeparator = extension.indexOf(46);
        }
        if (contentType == null) {
            return UNKNOWN_CONTENT_TYPE;
        }
        return contentType;
    }

    private ContentTypeUtil() {
    }

    static {
        try (InputStream inputStream = WebResourceUtil.class.getResourceAsStream("/META-INF/default-content-types.properties");){
            DEFAULT_CONTENT_TYPES.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

