/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.felix.utils.version.VersionRange;
import org.everit.osgi.webresource.WebResource;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.internal.LibContainer;
import org.everit.osgi.webresource.internal.WebResourceImpl;
import org.osgi.framework.Bundle;

public class WebResourceContainerImpl
implements WebResourceContainer {
    private final Map<String, LibContainer> libContainersByName = new ConcurrentSkipListMap<String, LibContainer>();
    private final Map<Bundle, Set<WebResource>> webResourcesByBundles = new ConcurrentHashMap<Bundle, Set<WebResource>>();

    public synchronized void addWebResource(WebResourceImpl webResource) {
        Bundle bundle = webResource.getBundle();
        Set<WebResource> resources = this.webResourcesByBundles.get(bundle);
        if (resources == null) {
            resources = Collections.newSetFromMap(new ConcurrentHashMap());
            this.webResourcesByBundles.put(bundle, resources);
        }
        resources.add(webResource);
        String library = webResource.getLibrary();
        LibContainer libContainer = this.libContainersByName.get(library);
        if (libContainer == null) {
            libContainer = new LibContainer();
            this.libContainersByName.put(library, libContainer);
        }
        libContainer.addWebResource(webResource);
    }

    @Override
    public Optional<WebResource> findWebResource(String lib, String resourceName, Optional<String> version) {
        Objects.requireNonNull(lib, "WebResource library must not be null");
        Objects.requireNonNull(lib, "WebResource name must not be null");
        LibContainer libContainer = this.libContainersByName.get(lib);
        if (libContainer == null) {
            return Optional.empty();
        }
        VersionRange versionRange = VersionRange.parseVersionRange((String)version.orElse(null));
        return libContainer.findWebResource(resourceName, versionRange);
    }

    Map<String, LibContainer> getLibContainersByName() {
        return this.libContainersByName;
    }

    public synchronized void removeBundle(Bundle bundle) {
        Set<WebResource> webResources = this.webResourcesByBundles.remove(bundle);
        for (WebResource webResource : webResources) {
            String library = webResource.getLibrary();
            LibContainer libContainer = this.libContainersByName.get(library);
            libContainer.removeWebResource(webResource);
            if (!libContainer.isEmpty()) continue;
            this.libContainersByName.remove(library);
        }
    }
}

