/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.osgi.webresource.ContentEncoding;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.internal.LibContainer;
import org.everit.osgi.webresource.internal.WebResourceContainerImpl;
import org.everit.osgi.webresource.internal.WebResourceImpl;
import org.everit.osgi.webresource.internal.WebResourceInternalUtil;
import org.everit.osgi.webresource.internal.WebconsoleHttpServletRequest;
import org.everit.osgi.webresource.util.WebResourceUtil;
import org.osgi.framework.Version;

public class WebResourceWebConsolePlugin
implements Servlet {
    private final WebResourceContainerImpl resourceContainer;
    private final WebResourceContainer webResourceContainer;

    public WebResourceWebConsolePlugin(WebResourceContainerImpl resourceContainer, WebResourceContainer webResourceContainer) {
        this.resourceContainer = resourceContainer;
        this.webResourceContainer = webResourceContainer;
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return "Everit WebResource Webconsole plugin";
    }

    private String getStringValue(Integer value) {
        if (value == null) {
            return "empty";
        }
        return value.toString();
    }

    public void init(ServletConfig config) throws ServletException {
    }

    private void respondPluginPage(ServletResponse resp, String pluginRootURI) throws IOException {
        PrintWriter writer = resp.getWriter();
        writer.write("<table class='content'>");
        this.writeTableHead(writer);
        writer.write("<tbody>");
        int rawCacheSizeSum = 0;
        int deflateCacheSizeSum = 0;
        int gzipCacheSizeSum = 0;
        Map<String, LibContainer> libContainersByName = this.resourceContainer.getLibContainersByName();
        DecimalFormat format = new DecimalFormat();
        for (Map.Entry<String, LibContainer> libContainersByNameEntry : libContainersByName.entrySet()) {
            String library = libContainersByNameEntry.getKey();
            LibContainer libContainer = libContainersByNameEntry.getValue();
            Map<String, NavigableMap<Version, Set<WebResourceImpl>>> versionedResourcesByName = libContainer.getVersionedResourcesByName();
            for (Map.Entry<String, NavigableMap<Version, Set<WebResourceImpl>>> versionedResourcesByNameEntry : versionedResourcesByName.entrySet()) {
                String fileName = versionedResourcesByNameEntry.getKey();
                NavigableMap<Version, Set<WebResourceImpl>> resourcesByVersion = versionedResourcesByNameEntry.getValue();
                for (Map.Entry resourcesByVersionEntry : resourcesByVersion.entrySet()) {
                    Version version = (Version)resourcesByVersionEntry.getKey();
                    Set resources = (Set)resourcesByVersionEntry.getValue();
                    for (WebResourceImpl resource : resources) {
                        writer.write("<tr><td class='content'>" + library + "</td>");
                        writer.write("<td class='content'><a href=\"" + pluginRootURI + "/" + library + ("".equals(library) ? "" : "/") + fileName + ".resource?" + "version" + "=[" + version.toString() + "," + version.toString() + "]\">" + fileName + "</a></td>");
                        writer.write("<td class='content'>" + version + "</td>");
                        writer.write("<td class='content'>" + resource.getContentType() + "</td>");
                        writer.write("<td class='content'>" + resource.getRawLength() + "</td>");
                        writer.write("<td class='content'>" + resource.getBundle().toString() + "</td>");
                        Map<ContentEncoding, Integer> cacheState = resource.getCacheState();
                        Integer rawCacheSize = cacheState.get((Object)ContentEncoding.RAW);
                        rawCacheSizeSum += rawCacheSize == null ? 0 : rawCacheSize;
                        writer.write("<td class='content'>" + this.getStringValue(rawCacheSize) + "</td>");
                        Integer deflateCacheSize = cacheState.get((Object)ContentEncoding.DEFLATE);
                        deflateCacheSizeSum += deflateCacheSize == null ? 0 : deflateCacheSize;
                        writer.write("<td class='content'>" + this.getStringValue(deflateCacheSize) + "</td>");
                        Integer gzipCacheSize = cacheState.get((Object)ContentEncoding.GZIP);
                        gzipCacheSizeSum += gzipCacheSize == null ? 0 : gzipCacheSize;
                        writer.write("<td class='content'>" + this.getStringValue(gzipCacheSize) + "</td></tr>");
                    }
                }
            }
        }
        writer.write("</tbody>");
        writer.write("</table>");
        writer.write("<table class='content'>");
        writer.write("<tr><th class='content container' colspan='2'>Cache state</th></tr>");
        writer.write("<tr><td class='content'>Raw</td><td class='content'>" + format.format(rawCacheSizeSum) + "</td></tr>");
        writer.write("<tr><td class='content'>Deflate</td><td class='content'>" + format.format(deflateCacheSizeSum) + "</td></tr>");
        writer.write("<tr><td class='content'>GZip</td><td class='content'>" + format.format(gzipCacheSizeSum) + "</td></tr>");
        writer.write("<tr><td class='content'>Sum</td><td class='content'>" + format.format(rawCacheSizeSum + deflateCacheSizeSum + gzipCacheSizeSum) + "</td></tr>");
        writer.write("</table>");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpReq = (HttpServletRequest)WebResourceInternalUtil.cast(req);
        HttpServletResponse httpRes = (HttpServletResponse)WebResourceInternalUtil.cast(res);
        String pluginRootURI = (String)req.getAttribute("felix.webconsole.pluginRoot");
        String requestURI = httpReq.getRequestURI();
        if (requestURI.equals(pluginRootURI)) {
            this.respondPluginPage(res, pluginRootURI);
        } else if (requestURI.endsWith(".resource")) {
            WebconsoleHttpServletRequest noAsyncRequest = new WebconsoleHttpServletRequest(httpReq);
            WebResourceUtil.findWebResourceAndWriteResponse(this.webResourceContainer, (HttpServletRequest)noAsyncRequest, httpRes);
        } else {
            httpRes.sendError(404);
        }
    }

    private void writeTableHead(PrintWriter writer) {
        writer.write("<thead>");
        writer.write("<tr><th class='content container' colspan='8'>Web resources</th></tr>");
        writer.write("<tr><th class='content'>Library</th>");
        writer.write("<th class='content'>File</th>");
        writer.write("<th class='content'>Version</th>");
        writer.write("<th class='content'>Content type</th>");
        writer.write("<th class='content'>Size</th>");
        writer.write("<th class='content'>Bundle</th>");
        writer.write("<th class='content'>Raw</th>");
        writer.write("<th class='content'>Deflate</th>");
        writer.write("<th class='content'>GZip</th></tr>");
        writer.write("</thead>");
    }
}

