/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.servlet.ServletContext;
import org.everit.osgi.webresource.WebResourceURIGenerator;
import org.everit.osgi.webresource.util.WebResourceUtil;

public class CommonContextWebResourceURIGenerator
implements WebResourceURIGenerator {
    private final Collection<WebResourceURIGenerator> uriGeneratorQueue;

    public CommonContextWebResourceURIGenerator(ServletContext context) {
        this.uriGeneratorQueue = WebResourceUtil.getUriGeneratorsOfServletContext(context);
    }

    @Override
    public Optional<String> generateURI(String lib, String file, Optional<String> versionRange) {
        if (this.uriGeneratorQueue == null) {
            return Optional.empty();
        }
        String result = null;
        Iterator<WebResourceURIGenerator> iterator = this.uriGeneratorQueue.iterator();
        while (result == null && iterator.hasNext()) {
            WebResourceURIGenerator nextItemObject = iterator.next();
            if (!(nextItemObject instanceof WebResourceURIGenerator)) continue;
            WebResourceURIGenerator webResourceURIGenerator = nextItemObject;
            result = webResourceURIGenerator.generateURI(lib, file, versionRange).orElse(null);
        }
        return Optional.ofNullable(result);
    }
}

