/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public enum ContentEncoding {
    DEFLATE("deflate"),
    GZIP("gzip"),
    RAW("raw");

    private final String headerValue;

    public static ContentEncoding resolveEncoding(HttpServletRequest request) {
        String acceptEncodingHeader = request.getHeader("Accept-Encoding");
        if (acceptEncodingHeader == null) {
            return RAW;
        }
        String[] encodings = acceptEncodingHeader.split(",");
        List<String> encodingList = Arrays.asList(encodings);
        if (encodingList.contains(GZIP.getHeaderValue())) {
            return GZIP;
        }
        if (encodingList.contains(DEFLATE.getHeaderValue())) {
            return DEFLATE;
        }
        return RAW;
    }

    private ContentEncoding(String headerValue) {
        this.headerValue = headerValue;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }
}

