/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.WebResourceURIGenerator;
import org.everit.osgi.webresource.internal.WebResourceInternalUtil;
import org.everit.osgi.webresource.internal.WebResourceServletURIGenerator;
import org.everit.osgi.webresource.util.WebResourceUtil;

public class WebResourceServlet
implements Servlet {
    private Context context;
    private ServletConfig servletConfig;
    private WebResourceServletURIGenerator uriGenerator;
    private final WebResourceContainer webResourceContainer;

    public WebResourceServlet(WebResourceContainer webResourceContainer) {
        this.webResourceContainer = webResourceContainer;
    }

    public void destroy() {
        ConcurrentLinkedQueue<WebResourceURIGenerator> uriGenerators = this.getOrCreateURIGeneratorQueue();
        uriGenerators.remove(this.uriGenerator);
        this.uriGenerator = null;
        this.context = null;
    }

    private ConcurrentLinkedQueue<WebResourceURIGenerator> getOrCreateURIGeneratorQueue() {
        String attributeName;
        ServletContext servletContext = this.getServletConfig().getServletContext();
        ConcurrentLinkedQueue uriGeneratorQueue = (ConcurrentLinkedQueue)servletContext.getAttribute(attributeName = WebResourceURIGenerator.class.getName());
        if (uriGeneratorQueue == null) {
            uriGeneratorQueue = new ConcurrentLinkedQueue();
            servletContext.setAttribute(attributeName, uriGeneratorQueue);
        }
        return uriGeneratorQueue;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "Everit WebResource";
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        String servletName = config.getServletName();
        Objects.requireNonNull(servletName, "Servlet name must not be null!");
        if (this.context != null && !Objects.equals(this.context.servletName, servletName)) {
            throw new IllegalStateException("The same WebResource servlet instance was initialized with different servlet names");
        }
        ServletContext servletContext = config.getServletContext();
        if (servletContext != null) {
            if (this.context != null && !Objects.equals(this.context.servletContext, servletContext)) {
                throw new IllegalStateException("The same WebResource servlet instance was initialized with different servlet contexts");
            }
            String contextPath = servletContext.getContextPath();
            ServletRegistration servletRegistration = servletContext.getServletRegistration(servletName);
            Collection mappings = servletRegistration.getMappings();
            if (mappings.size() > 0) {
                String mapping = (String)mappings.iterator().next();
                if (this.uriGenerator == null) {
                    this.uriGenerator = new WebResourceServletURIGenerator(this.webResourceContainer, contextPath, mapping);
                    this.getOrCreateURIGeneratorQueue().add(this.uriGenerator);
                } else {
                    this.uriGenerator.update(contextPath, mapping);
                }
            } else if (this.uriGenerator != null) {
                this.getOrCreateURIGeneratorQueue().remove(this.uriGenerator);
                this.uriGenerator = null;
            }
            this.context = new Context(servletContext, servletName);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpReq = (HttpServletRequest)WebResourceInternalUtil.cast(req);
        HttpServletResponse httpRes = (HttpServletResponse)WebResourceInternalUtil.cast(res);
        WebResourceUtil.findWebResourceAndWriteResponse(this.webResourceContainer, httpReq, httpRes);
    }

    private static class Context {
        public final ServletContext servletContext;
        public final String servletName;

        Context(ServletContext servletContext, String servletName) {
            this.servletContext = servletContext;
            this.servletName = servletName;
        }
    }
}

