/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.everit.osgi.webresource.WebResource;
import org.everit.osgi.webresource.WebResourceContainer;
import org.everit.osgi.webresource.WebResourceURIGenerator;

public class WebResourceServletURIGenerator
implements WebResourceURIGenerator {
    private String pathPrefix;
    private String pathSuffix;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final WebResourceContainer webResourceContainer;

    public WebResourceServletURIGenerator(WebResourceContainer webResourceContainer, String contextPath, String urlPattern) {
        this.webResourceContainer = webResourceContainer;
        this.update(contextPath, urlPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> generateURI(String lib, String file, Optional<String> versionRange) {
        String lPathSuffix;
        String lPathPrefix;
        Optional<WebResource> webResource = this.webResourceContainer.findWebResource(lib, file, versionRange);
        if (!webResource.isPresent()) {
            return Optional.empty();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            lPathPrefix = this.pathPrefix;
            lPathSuffix = this.pathSuffix;
        }
        finally {
            readLock.unlock();
        }
        StringBuilder sb = new StringBuilder(lPathPrefix).append("/");
        if (lib != null && lib.length() > 0) {
            sb.append(lib).append("/");
        }
        sb.append(file);
        sb.append(lPathSuffix);
        char parameterSeparator = '?';
        if (versionRange.isPresent() && versionRange.get().length() > 0) {
            parameterSeparator = '&';
            sb.append(parameterSeparator).append("version=").append(versionRange);
        }
        sb.append(parameterSeparator).append("t=").append(webResource.get().getLastModified());
        return Optional.of(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(String contextPath, String urlPattern) {
        String pathPrefixResult = contextPath;
        if (pathPrefixResult.endsWith("/")) {
            pathPrefixResult = pathPrefixResult.substring(0, pathPrefixResult.length() - 1);
        }
        String pathSuffixResult = "";
        if (urlPattern.startsWith("*")) {
            pathSuffixResult = urlPattern.substring(1);
        } else {
            String patternForPrefix = urlPattern;
            if (patternForPrefix.endsWith("*")) {
                patternForPrefix = urlPattern.substring(0, urlPattern.length() - 1);
            }
            if (patternForPrefix.startsWith("/")) {
                patternForPrefix = patternForPrefix.substring(1);
            }
            if (patternForPrefix.endsWith("/")) {
                patternForPrefix = patternForPrefix.substring(0, patternForPrefix.length() - 1);
            }
            if (patternForPrefix.length() > 0) {
                pathPrefixResult = pathPrefixResult + "/" + patternForPrefix;
            }
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.pathPrefix = pathPrefixResult;
            this.pathSuffix = pathSuffixResult;
        }
        finally {
            writeLock.unlock();
        }
    }
}

