/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.everit.osgi.webresource.ContentEncoding;
import org.everit.osgi.webresource.WebResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WebResourceImpl
implements WebResource {
    private static final int COPY_BUFFER_SIZE = 1024;
    private final Bundle bundle;
    private final Map<ContentEncoding, byte[]> cache = new ConcurrentHashMap<ContentEncoding, byte[]>();
    private final String contentType;
    private final String etag;
    private final String fileName;
    private final long lastModified;
    private final String lastModifiedRFC1123GMT;
    private final String library;
    private final int rawLength;
    private final URL resourceURL;
    private final Version version;

    public WebResourceImpl(Bundle bundle, String library, String fileName, URL resourceURL, Version version, String contentType) {
        this.resourceURL = resourceURL;
        this.bundle = bundle;
        this.contentType = contentType;
        try {
            URLConnection urlConnection = resourceURL.openConnection();
            this.lastModified = urlConnection.getLastModified();
            this.rawLength = urlConnection.getContentLength();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.fileName = fileName;
        this.version = version;
        this.library = library;
        this.etag = this.resolveETag();
        this.lastModifiedRFC1123GMT = this.resolveLastModifiedRFC1123();
    }

    public void destroy() {
        this.cache.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebResourceImpl other = (WebResourceImpl)obj;
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Map<ContentEncoding, Integer> getCacheState() {
        ContentEncoding[] contentEncodings;
        HashMap<ContentEncoding, Integer> result = new HashMap<ContentEncoding, Integer>();
        for (ContentEncoding contentEncoding : contentEncodings = ContentEncoding.values()) {
            byte[] cachedData = this.cache.get((Object)contentEncoding);
            if (cachedData == null) continue;
            result.put(contentEncoding, cachedData.length);
        }
        return result;
    }

    private byte[] getContentData(ContentEncoding contentEncoding) {
        byte[] contentData = this.cache.get((Object)contentEncoding);
        if (contentData == null) {
            contentData = this.readContentIntoCache(contentEncoding);
        }
        return contentData;
    }

    @Override
    public long getContentLength(ContentEncoding contentEncoding) {
        return this.getContentData(contentEncoding).length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getETag() {
        return this.etag;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public InputStream getInputStream(ContentEncoding contentEncoding, int beginIndex) throws IOException {
        byte[] contentData = this.getContentData(contentEncoding);
        ByteArrayInputStream bin = new ByteArrayInputStream(contentData, beginIndex, contentData.length - beginIndex);
        return bin;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getLastModifiedRFC1123GMT() {
        return this.lastModifiedRFC1123GMT;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public int getRawLength() {
        return this.rawLength;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.library == null ? 0 : this.library.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    private synchronized byte[] readContentIntoCache(ContentEncoding contentEncoding) {
        byte[] contentData = this.cache.get((Object)contentEncoding);
        if (contentData == null) {
            try (InputStream inputStream = this.resourceURL.openStream();){
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStream out = ContentEncoding.GZIP.equals((Object)contentEncoding) ? new GZIPOutputStream(bout) : (ContentEncoding.DEFLATE.equals((Object)contentEncoding) ? new DeflaterOutputStream(bout) : bout);
                byte[] buf = new byte[1024];
                int r = inputStream.read(buf);
                while (r > -1) {
                    out.write(buf, 0, r);
                    r = inputStream.read(buf);
                }
                out.close();
                contentData = bout.toByteArray();
                this.cache.put(contentEncoding, contentData);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return contentData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveETag() {
        try (InputStream in = this.resourceURL.openStream();){
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Charset defaultCharset = Charset.forName("UTF8");
            messageDigest.update(this.library.getBytes(defaultCharset));
            messageDigest.update(this.fileName.getBytes(defaultCharset));
            messageDigest.update(this.version.toString().getBytes(defaultCharset));
            byte[] buf = new byte[1024];
            int r = in.read(buf);
            while (r > -1) {
                messageDigest.update(buf, 0, r);
                r = in.read(buf);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(messageDigest.digest());
            bout.write(this.longToBytes(this.lastModified));
            String string = String.format("%x", new BigInteger(1, bout.toByteArray()));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveLastModifiedRFC1123() {
        Instant instant = Instant.ofEpochMilli(this.lastModified);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("GMT"));
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime);
    }
}

