/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.webresource.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.felix.utils.version.VersionRange;
import org.everit.osgi.webresource.WebResource;
import org.everit.osgi.webresource.internal.WebResourceImpl;
import org.osgi.framework.Version;

public class LibContainer {
    private final Map<String, NavigableMap<Version, Set<WebResourceImpl>>> versionedResourcesByName = new ConcurrentSkipListMap<String, NavigableMap<Version, Set<WebResourceImpl>>>();

    public synchronized void addWebResource(WebResourceImpl resource) {
        Version version;
        Set resources;
        String fileName = resource.getFileName();
        NavigableMap<Version, Set<WebResourceImpl>> resourcesByVersion = this.versionedResourcesByName.get(fileName);
        if (resourcesByVersion == null) {
            resourcesByVersion = new ConcurrentSkipListMap<Version, Set<WebResourceImpl>>();
            this.versionedResourcesByName.put(fileName, resourcesByVersion);
        }
        if ((resources = (Set)resourcesByVersion.get(version = resource.getVersion())) == null) {
            resources = Collections.newSetFromMap(new ConcurrentHashMap());
            resourcesByVersion.put(version, resources);
        }
        resources.add(resource);
    }

    public Optional<WebResource> findWebResource(String resourceName, VersionRange versionRange) {
        NavigableMap<Version, Set<WebResourceImpl>> resourceByVersion = this.versionedResourcesByName.get(resourceName);
        if (resourceByVersion == null || resourceByVersion.size() == 0) {
            return Optional.empty();
        }
        if (versionRange == null || versionRange.getCeiling().equals((Object)VersionRange.INFINITE_VERSION)) {
            Optional<WebResource> optionalWebResource = this.selectResourceWithHighestVersion(resourceByVersion);
            if (optionalWebResource.isPresent()) {
                WebResource webResource = optionalWebResource.get();
                Version version = webResource.getVersion();
                if (versionRange.contains(version)) {
                    return Optional.of(webResource);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        if (versionRange.isPointVersion()) {
            Set resources = (Set)resourceByVersion.get(versionRange.getFloor());
            return this.selectResourceFromSet(resources);
        }
        Optional<WebResource> result = null;
        Version ceilingVersion = versionRange.getCeiling();
        Map.Entry<Version, Set<WebResourceImpl>> potentialEntry = this.resolvePotentialEntriesByVersionRange(versionRange, resourceByVersion, ceilingVersion);
        if (potentialEntry != null && versionRange.contains(potentialEntry.getKey())) {
            result = this.selectResourceFromSet(potentialEntry.getValue());
        }
        return result;
    }

    Map<String, NavigableMap<Version, Set<WebResourceImpl>>> getVersionedResourcesByName() {
        return this.versionedResourcesByName;
    }

    public boolean isEmpty() {
        return this.versionedResourcesByName.size() == 0;
    }

    public synchronized void removeWebResource(WebResource resource) {
        String fileName = resource.getFileName();
        NavigableMap<Version, Set<WebResourceImpl>> resourcesByVersion = this.versionedResourcesByName.get(fileName);
        Version version = resource.getVersion();
        Set resources = (Set)resourcesByVersion.get(version);
        resources.remove(resource);
        if (resources.size() == 0) {
            resourcesByVersion.remove(version);
            if (resourcesByVersion.size() == 0) {
                this.versionedResourcesByName.remove(fileName);
            }
        }
    }

    private Map.Entry<Version, Set<WebResourceImpl>> resolvePotentialEntriesByVersionRange(VersionRange versionRange, NavigableMap<Version, Set<WebResourceImpl>> resourceByVersion, Version ceilingVersion) {
        Map.Entry<Version, Set<WebResourceImpl>> potentialEntry = null;
        potentialEntry = !versionRange.isOpenCeiling() ? resourceByVersion.floorEntry(ceilingVersion) : resourceByVersion.lowerEntry(ceilingVersion);
        return potentialEntry;
    }

    private Optional<WebResource> selectResourceFromSet(Set<WebResourceImpl> resources) {
        if (resources == null) {
            return Optional.empty();
        }
        Iterator<WebResourceImpl> iterator = resources.iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    private Optional<WebResource> selectResourceWithHighestVersion(NavigableMap<Version, Set<WebResourceImpl>> resourceByVersion) {
        Map.Entry<Version, Set<WebResourceImpl>> lastEntry = resourceByVersion.lastEntry();
        if (lastEntry != null) {
            return this.selectResourceFromSet(lastEntry.getValue());
        }
        return Optional.empty();
    }
}

