/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.backgroundjobs;

import java.util.ArrayList;
import java.util.List;
import org.evolvis.tartools.backgroundjobs.BackgroundJob;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.evolvis.tartools.backgroundjobs.WeightedBackgroundJob;

public class CompositeBackgroundJob
implements BackgroundJob<List<?>> {
    private final BackgroundJob<?>[] steps;
    private BackgroundJob<?> currentStep = null;
    private final String description;
    private int progressOffset = 0;

    public CompositeBackgroundJob(String description, BackgroundJob<?> ... steps) {
        this.description = description;
        this.steps = steps;
    }

    @Override
    public List<?> work(BackgroundJobMonitor monitor) throws Exception {
        ArrayList arrayList = new ArrayList();
        int total = 0;
        for (BackgroundJob<?> step : this.steps) {
            total += this.getWeight(step);
        }
        monitor.announceTotal(total * 100);
        for (BackgroundJob<?> step : this.steps) {
            if (monitor.isAborting()) break;
            this.currentStep = step;
            int anteilVomGanzen = 100 * this.getWeight(step);
            arrayList.add(step.work(new SubJobMonitor(monitor, anteilVomGanzen)));
            this.progressOffset += anteilVomGanzen;
        }
        return arrayList;
    }

    private int getWeight(BackgroundJob<?> step) {
        return step instanceof WeightedBackgroundJob ? ((WeightedBackgroundJob)step).getWeight() : 1;
    }

    @Override
    public String getDescription() {
        return this.currentStep == null ? this.description : this.description + " / " + this.currentStep.getDescription();
    }

    public class SubJobMonitor
    implements BackgroundJobMonitor {
        private final BackgroundJobMonitor monitor;
        private final int anteilVomGanzen;
        private int subTotal;
        private int itemCount = 0;

        public SubJobMonitor(BackgroundJobMonitor monitor, int anteilVomGanzen) {
            this.monitor = monitor;
            this.anteilVomGanzen = anteilVomGanzen;
        }

        @Override
        public String getScheduledJobId() {
            return this.monitor.getScheduledJobId();
        }

        @Override
        public void log(BackgroundJobMonitor.Severity severity, Object message) {
            this.monitor.log(severity, message);
        }

        @Override
        public void announceTotal(int totalItems) {
            this.subTotal = totalItems;
        }

        @Override
        public void reportProgressIncrement(int items) {
            this.itemCount += items;
            this.reportAbsolute();
        }

        @Override
        public void reportProgressAbsolute(int items) {
            this.itemCount = items;
            this.reportAbsolute();
        }

        private void reportAbsolute() {
            if (this.subTotal == 0) {
                this.monitor.reportProgressAbsolute(CompositeBackgroundJob.this.progressOffset);
            } else {
                this.monitor.reportProgressAbsolute(CompositeBackgroundJob.this.progressOffset + this.itemCount * this.anteilVomGanzen / this.subTotal);
            }
        }

        @Override
        public boolean isAborting() {
            return this.monitor.isAborting();
        }
    }
}

