/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.csvfile;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.evolvis.tartools.csvfile.CSVFile;

public class CSVFileReader
extends CSVFile {
    private final BufferedReader in;
    private String line = null;

    public CSVFileReader(String inputFileName) throws FileNotFoundException {
        this(inputFileName, ',');
    }

    public CSVFileReader(Reader reader) {
        this(reader, ',');
    }

    public CSVFileReader(String inputFileName, String charsetName) throws FileNotFoundException, UnsupportedEncodingException {
        this(inputFileName, charsetName, ',');
    }

    public CSVFileReader(InputStream stream, String charsetName) throws UnsupportedEncodingException {
        this(stream, charsetName, ',');
    }

    public CSVFileReader(String inputFileName, char sep) throws FileNotFoundException {
        this(inputFileName, sep, '\"');
    }

    public CSVFileReader(Reader reader, char sep) {
        this(reader, sep, '\"');
    }

    public CSVFileReader(String inputFileName, String charsetName, char sep) throws FileNotFoundException, UnsupportedEncodingException {
        this(inputFileName, charsetName, sep, '\"');
    }

    public CSVFileReader(InputStream stream, String charsetName, char sep) throws UnsupportedEncodingException {
        this(stream, charsetName, sep, '\"');
    }

    public CSVFileReader(String inputFileName, char sep, char qual) throws FileNotFoundException {
        this(new FileReader(inputFileName), sep, qual);
    }

    public CSVFileReader(Reader reader, char sep, char qual) {
        super(sep, qual);
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public CSVFileReader(String inputFileName, String charsetName, char sep, char qual) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(inputFileName), charsetName, sep, qual);
    }

    public CSVFileReader(InputStream stream, String charsetName, char sep, char qual) throws UnsupportedEncodingException {
        super(sep, qual);
        this.in = new BufferedReader(new InputStreamReader(stream, charsetName));
    }

    public List<String> readFields() throws IOException {
        return this.readFields(this.in.readLine());
    }

    public List<String> readFields(String firstLine) throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        this.line = firstLine;
        if (this.line == null) {
            return null;
        }
        if (this.line.length() == 0) {
            fields.add(this.line);
            return fields;
        }
        int i = 0;
        do {
            sb.setLength(0);
            if (i < this.line.length() && this.line.charAt(i) == this.textQualifier) {
                ++i;
                i = this.handleQuotedField(sb, i);
            } else {
                i = this.handlePlainField(sb, i);
            }
            fields.add(sb.toString());
        } while (++i < this.line.length());
        return fields;
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected int handleQuotedField(StringBuilder sb, int i) throws IOException {
        int j;
        int len = this.line.length();
        for (j = i; j < len; ++j) {
            if (this.line.charAt(j) == this.textQualifier) {
                if (j + 1 == len) break;
                if (this.line.charAt(j + 1) == this.textQualifier) {
                    ++j;
                } else if (this.line.charAt(j + 1) == this.fieldSeparator) {
                    ++j;
                    break;
                }
            }
            sb.append(this.line.charAt(j));
        }
        if (j >= len) {
            this.line = this.in.readLine();
            if (this.line == null) {
                this.line = String.valueOf(this.textQualifier);
                return 0;
            }
            sb.append('\n');
            return this.handleQuotedField(sb, 0);
        }
        return j;
    }

    protected int handlePlainField(StringBuilder sb, int i) {
        int j = this.line.indexOf(this.fieldSeparator, i);
        if (j == -1) {
            sb.append(this.line.substring(i));
            return this.line.length();
        }
        sb.append(this.line, i, j);
        return j;
    }
}

