/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.csvfile;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.evolvis.tartools.csvfile.CSVFile;

public class CSVFileWriter
extends CSVFile {
    protected final PrintWriter out;

    public CSVFileWriter(String outputFileName) throws IOException {
        this(outputFileName, ',');
    }

    public CSVFileWriter(String outputFileName, char sep) throws IOException {
        this(outputFileName, sep, '\"');
    }

    public CSVFileWriter(String outputFileName, char sep, char qual) throws IOException {
        this(new FileWriter(outputFileName), sep, qual);
    }

    public CSVFileWriter(Writer writer, char sep, char qual) {
        super(sep, qual);
        this.out = new PrintWriter(new BufferedWriter(writer));
    }

    public void close() {
        this.out.flush();
        this.out.close();
    }

    public void writeFields(List<?> fields) {
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            this.out.print(this.prepareField(fields.get(i)));
            if (i >= n - 1) continue;
            this.out.print(this.fieldSeparator);
        }
        this.emitRowSeparator();
    }

    protected void emitRowSeparator() {
        this.out.println();
    }

    protected String prepareField(Object field) {
        String fieldString;
        String string = fieldString = field == null ? "" : field.toString();
        if (fieldString.indexOf(this.fieldSeparator) >= 0 || fieldString.indexOf(10) >= 0 || fieldString.indexOf(13) >= 0 || fieldString.indexOf(this.textQualifier) == 0) {
            return this.textQualifier + fieldString.replaceAll(String.valueOf(this.textQualifier), new String(new char[]{this.textQualifier, this.textQualifier})) + this.textQualifier;
        }
        return fieldString;
    }
}

