/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.csvfile;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.evolvis.tartools.csvfile.CSVFileReader;

public class SSVFileReader
extends CSVFileReader {
    private String decodeNewline = System.lineSeparator();
    static final int BUFSIZ = 4096;
    private static final char[] BUF = new char[4096];

    public SSVFileReader(String inputFileName) throws FileNotFoundException {
        this(new FileInputStream(inputFileName));
    }

    public SSVFileReader(InputStream stream) {
        this(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public SSVFileReader(Reader reader) {
        super(reader, '\u001c', '\u0000');
    }

    @Override
    public void setFieldSeparator(char sep) {
        throw new UnsupportedOperationException("SSV does not allow changing the field separator");
    }

    @Override
    public void setTextQualifier(char qual) {
        throw new UnsupportedOperationException("SSV does not have a quote character");
    }

    @Override
    public char getTextQualifier() {
        throw new UnsupportedOperationException("SSV does not have a quote character");
    }

    String inReadLine() throws IOException {
        boolean found = false;
        StringBuilder sb = null;
        while (!found) {
            this.in.mark(4098);
            int nch = this.in.read(BUF, 0, 4096);
            if (sb == null) {
                if (nch == -1) {
                    return null;
                }
                sb = new StringBuilder();
            } else if (nch == -1) break;
            for (int i = 0; i < nch; ++i) {
                if (BUF[i] != '\n') continue;
                sb.append(BUF, 0, i);
                this.in.reset();
                nch = i + 1;
                while (nch != 0) {
                    nch = (int)((long)nch - this.in.skip(nch));
                }
                found = true;
                break;
            }
            if (found) continue;
            sb.append(BUF, 0, nch);
        }
        return sb.toString();
    }

    @Override
    public List<String> readFields() throws IOException {
        String line = this.inReadLine();
        if (line == null) {
            return null;
        }
        if (line.indexOf(0) != -1) {
            line = line.substring(0, line.indexOf(0));
        }
        return this.readFields(line);
    }

    @Override
    protected boolean fieldIsQuoted(int i) {
        return false;
    }

    @Override
    protected void addField(List<String> fields, String field) {
        fields.add(field.replace("\r", this.decodeNewline));
    }

    public void useUnixNewline() {
        this.decodeNewline = "\n";
    }
}

