/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.csvfile;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.evolvis.tartools.csvfile.CSVFile;

public class CSVFileWriter
extends CSVFile {
    protected final PrintWriter out;
    protected String rowSeparator = "\n";

    public CSVFileWriter(String outputFileName) throws IOException {
        this(new FileWriter(outputFileName));
    }

    public CSVFileWriter(Writer writer) {
        this(writer, ',', '\"');
    }

    public CSVFileWriter(OutputStream stream) {
        this(stream, ',', '\"');
    }

    public CSVFileWriter(String outputFileName, char sep) throws IOException {
        this(outputFileName, sep, '\"');
    }

    public CSVFileWriter(String outputFileName, char sep, char qual) throws IOException {
        this(new FileWriter(outputFileName), sep, qual);
    }

    public CSVFileWriter(OutputStream stream, char sep, char qual) {
        this(new OutputStreamWriter(stream, StandardCharsets.UTF_8), sep, qual);
    }

    public CSVFileWriter(Writer writer, char sep, char qual) {
        super(sep, qual);
        this.out = new PrintWriter(new BufferedWriter(writer));
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRowSeparator(String separator) {
        this.rowSeparator = separator;
    }

    public void close() {
        this.out.flush();
        this.out.close();
    }

    public void writeFields(Iterable<?> fields) {
        boolean first = true;
        for (Object field : fields) {
            if (first) {
                first = false;
            } else {
                this.out.print(this.fieldSeparator);
            }
            this.out.print(this.prepareField(field));
        }
        this.out.print(this.rowSeparator);
    }

    protected String prepareField(Object field) {
        String fieldString;
        String string = fieldString = field == null ? "" : field.toString();
        if (fieldString.indexOf(this.fieldSeparator) >= 0 || fieldString.indexOf(10) >= 0 || fieldString.indexOf(13) >= 0 || fieldString.indexOf(this.textQualifier) >= 0) {
            return this.textQualifier + fieldString.replaceAll(String.valueOf(this.textQualifier), new String(new char[]{this.textQualifier, this.textQualifier})) + this.textQualifier;
        }
        return fieldString;
    }
}

