/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ResultSetValueExtractor;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.utils.ExtractorException;
import java.sql.ResultSet;
import java.util.Arrays;

public class RowProcessor {
    private final ResultSetValueExtractor[] extractors;
    private final Object[] buffer;
    private final int[] columns;
    private final Iterable<?> row;

    public RowProcessor(ResultSetValueExtractor ... extractors) {
        this.extractors = extractors;
        int[] columnsNew = new int[extractors.length];
        int j = 0;
        for (int i = 0; i < extractors.length; ++i) {
            if (extractors[i] == null) continue;
            columnsNew[j++] = i;
        }
        this.columns = new int[j];
        System.arraycopy(columnsNew, 0, this.columns, 0, j);
        this.buffer = new Object[j];
        this.row = Arrays.asList(this.buffer);
    }

    public void processRow(ResultSet rs, RowPrinter printer) {
        try {
            for (int i = 0; i < this.buffer.length; ++i) {
                int col = this.columns[i];
                this.buffer[i] = this.extractors[col].extractValue(rs, col);
            }
            printer.printRow(this.row);
        }
        catch (Exception e) {
            throw new ExtractorException(e);
        }
    }
}

