/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ExtractorQuery;
import de.tarent.extract.RowFetcher;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.RowProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DefaultRowFetcher
implements RowFetcher {
    private final JdbcTemplate jdbcTemplate;

    public DefaultRowFetcher(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void fetch(final ExtractorQuery query, final BackgroundJobMonitor monitor, final RowPrinter printer, final RowProcessor rowProcessor) {
        String sql = query.getOrderBy() == null ? query.getSql() : query.getSql() + " ORDER BY " + query.getOrderBy();
        this.jdbcTemplate.query(sql, new ResultSetExtractor<Void>(){

            @Override
            public Void extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rownum = 0;
                while (rs.next()) {
                    rowProcessor.processRow(rs, printer);
                    if (rownum++ % query.getProgressInterval() != 0) continue;
                    monitor.reportProgressAbsolute(rownum);
                }
                monitor.reportProgressAbsolute(rownum);
                return null;
            }
        });
    }
}

