/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

abstract class AbstractJacksonLayout
extends AbstractStringLayout {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_EOL = "\r\n";
    protected static final String COMPACT_EOL = "";
    protected final String eol;
    protected final ObjectWriter objectWriter;
    protected final boolean compact;
    protected final boolean complete;

    protected AbstractJacksonLayout(ObjectWriter objectWriter, Charset charset, boolean compact, boolean complete, boolean eventEol) {
        super(charset);
        this.objectWriter = objectWriter;
        this.compact = compact;
        this.complete = complete;
        this.eol = compact && !eventEol ? COMPACT_EOL : DEFAULT_EOL;
    }

    @Override
    public String toSerializable(LogEvent event) {
        try {
            return this.objectWriter.writeValueAsString(event) + this.eol;
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e);
            return COMPACT_EOL;
        }
    }
}

