/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.backgroundjobs;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.evolvis.tartools.backgroundjobs.BackgroundJob;
import org.evolvis.tartools.backgroundjobs.BackgroundJobInfo;
import org.evolvis.tartools.backgroundjobs.BackgroundJobLog;
import org.evolvis.tartools.backgroundjobs.BackgroundJobLogFactory;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.evolvis.tartools.backgroundjobs.BackgroundJobStatus;
import org.evolvis.tartools.backgroundjobs.BackgroundThread;
import org.evolvis.tartools.backgroundjobs.BackgroundThreadFactory;
import org.evolvis.tartools.backgroundjobs.FutureFactory;
import org.evolvis.tartools.backgroundjobs.JobEvent;
import org.evolvis.tartools.backgroundjobs.JobListener;

class ScheduledJob<T>
implements BackgroundJobStatus<T> {
    private final BackgroundThread thread;
    private final FutureTask<T> future;
    private int workDone;
    private int workTotal;
    private BackgroundJobInfo.State state = BackgroundJobInfo.State.SCHEDULED;
    private final ArrayList<JobListener> listeners = new ArrayList();
    private final Object stateLock = new Object();
    private final String description;
    private final Class<?> jobClass;
    private final String id;
    private boolean aborting;
    private long startTime;
    private long lastModified;
    private final boolean visible;
    private final boolean cancellationSupported;

    public ScheduledJob(BackgroundJob<T> job, BackgroundThreadFactory threadFactory, FutureFactory futureFactory, BackgroundJobLogFactory jobLogFactory) {
        this(UUID.randomUUID().toString(), job, threadFactory, futureFactory, jobLogFactory);
    }

    public ScheduledJob(final String id, final BackgroundJob<T> job, BackgroundThreadFactory threadFactory, FutureFactory futureFactory, final BackgroundJobLogFactory jobLogFactory) {
        this.id = id;
        this.description = job.getDescription();
        this.visible = job.isVisible();
        this.cancellationSupported = job.isCancellationSupported();
        this.jobClass = job.getClass();
        this.startTime = System.currentTimeMillis();
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                ScheduledJob.this.jobRunning();
                BackgroundJobLog jobLog = jobLogFactory.createJobLog(id);
                try (Monitor monitor = new Monitor(jobLog);){
                    Object result = job.work(monitor);
                    ScheduledJob.this.jobReturned();
                    Object v = result;
                    return v;
                }
            }
        };
        this.future = futureFactory.createFutureTask(callable);
        this.thread = threadFactory.createThread(this.future);
    }

    public void execute() {
        this.jobStarted();
        this.thread.start();
    }

    private void jobStarted() {
        this.setState(BackgroundJobInfo.State.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.getState() == BackgroundJobInfo.State.ABORTING_STARTING) {
                this.setState(BackgroundJobInfo.State.ABORTING);
                this.future.cancel(true);
            } else {
                this.setState(BackgroundJobInfo.State.RUNNING);
            }
        }
    }

    protected void jobRaisedException() {
        this.setState(BackgroundJobInfo.State.FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobReturned() {
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(this.getState() == BackgroundJobInfo.State.ABORTING ? BackgroundJobInfo.State.ABORTED : BackgroundJobInfo.State.SUCCEEDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.getState()) {
                case SCHEDULED: {
                    this.setState(BackgroundJobInfo.State.ABORTED);
                    this.future.cancel(true);
                    break;
                }
                case STARTING: {
                    this.setState(BackgroundJobInfo.State.ABORTING_STARTING);
                    break;
                }
                default: {
                    this.setState(BackgroundJobInfo.State.ABORTING);
                    this.future.cancel(true);
                }
            }
        }
    }

    @Override
    public void join(long timeout) throws InterruptedException {
        this.thread.join(timeout);
    }

    @Override
    public T result() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackgroundJobInfo.State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public int getWorkDone() {
        return this.workDone;
    }

    @Override
    public int getWorkTotal() {
        return this.workTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(BackgroundJobInfo.State newState) {
        BackgroundJobInfo.State oldState;
        Object object = this.stateLock;
        synchronized (object) {
            oldState = this.state;
            if (newState == oldState) {
                return;
            }
            if (newState == BackgroundJobInfo.State.ABORTING) {
                this.aborting = true;
            }
            this.state = newState;
        }
        this.fireStateChanged(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(JobListener l) {
        ArrayList<JobListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobListener(JobListener l) {
        ArrayList<JobListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(BackgroundJobInfo.State oldState, BackgroundJobInfo.State newState) {
        JobEvent e;
        ArrayList<JobListener> clonedListeners;
        this.lastModified = System.currentTimeMillis();
        ArrayList<JobListener> arrayList = this.listeners;
        synchronized (arrayList) {
            clonedListeners = new ArrayList<JobListener>(this.listeners);
            e = new JobEvent(this, oldState, newState);
        }
        for (JobListener jobListener : clonedListeners) {
            jobListener.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressInfoUpdated() {
        JobEvent e;
        ArrayList<JobListener> clonedListeners;
        this.lastModified = System.currentTimeMillis();
        ArrayList<JobListener> arrayList = this.listeners;
        synchronized (arrayList) {
            clonedListeners = new ArrayList<JobListener>(this.listeners);
            e = new JobEvent(this);
        }
        for (JobListener jobListener : clonedListeners) {
            jobListener.stateChanged(e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<?> getJobClass() {
        return this.jobClass;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isCancellationSupported() {
        return this.cancellationSupported;
    }

    private class Monitor
    implements BackgroundJobMonitor,
    BackgroundJobLog {
        private final BackgroundJobLog jobLog;

        public Monitor(BackgroundJobLog jobLog) {
            this.jobLog = jobLog;
        }

        @Override
        public String getScheduledJobId() {
            return ScheduledJob.this.getId();
        }

        @Override
        public boolean isAborting() {
            return ScheduledJob.this.aborting;
        }

        @Override
        public void log(BackgroundJobMonitor.Severity severity, Object message) {
            this.jobLog.log(severity, message);
        }

        @Override
        public void announceTotal(int totalItems) {
            ScheduledJob.this.workTotal = totalItems;
            ScheduledJob.this.fireProgressInfoUpdated();
        }

        @Override
        public void reportProgressIncrement(int items) {
            ScheduledJob.this.workDone += items;
            ScheduledJob.this.fireProgressInfoUpdated();
        }

        @Override
        public void reportProgressAbsolute(int items) {
            ScheduledJob.this.workDone = items;
            ScheduledJob.this.fireProgressInfoUpdated();
        }

        @Override
        public void close() {
            this.jobLog.close();
        }
    }
}

