/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;

public class ConsoleProgressMonitor
implements BackgroundJobMonitor {
    private final PrintWriter printWriter;
    private int total;
    private int done;
    private final int barWidth;
    private int lastLength = 0;
    private boolean hasEnded = false;

    public ConsoleProgressMonitor(PrintWriter printWriter, int barWidth) {
        this.printWriter = printWriter;
        this.barWidth = barWidth;
    }

    public void log(BackgroundJobMonitor.Severity severity, Object message) {
        this.printWriter.println(severity + ": " + message);
    }

    public boolean isAborting() {
        return false;
    }

    public String getScheduledJobId() {
        return "cli-job";
    }

    public void announceTotal(int totalItems) {
        this.total = totalItems;
    }

    public void reportProgressIncrement(int items) {
        this.done += items;
        this.printProgress();
    }

    private void printProgress() {
        StringWriter sb = new StringWriter();
        sb.write("Progress: [");
        for (int i = 0; i < this.barWidth; ++i) {
            double doneRatio = (double)this.done / (double)this.total;
            if ((double)i < doneRatio * (double)this.barWidth) {
                sb.write("=");
                continue;
            }
            sb.write(".");
        }
        sb.write("] ");
        sb.write("" + this.done);
        sb.write(" of ");
        sb.write("" + this.total);
        int currentLength = sb.toString().length();
        for (int i = sb.toString().length(); i < this.lastLength; ++i) {
            sb.append(' ');
        }
        this.lastLength = currentLength;
        this.printWriter.print(sb.toString());
        this.printWriter.print('\r');
        if (this.done < this.total) {
            this.hasEnded = false;
        } else if (!this.hasEnded) {
            this.printWriter.print('\n');
            this.hasEnded = true;
        }
        this.printWriter.flush();
    }

    public void reportProgressAbsolute(int items) {
        this.done = items;
        this.printProgress();
    }
}

