/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ConsoleProgressMonitor;
import de.tarent.extract.DummyMonitor;
import de.tarent.extract.ExtractIo;
import de.tarent.extract.utils.ExtractCliException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;

public class ExtractCli
implements ExtractIo {
    private File inputFile;
    private File outputFile;
    private String outputEncoding = "utf-8";
    private String inputEncoding = "utf-8";
    private Properties properties = null;
    private ClassLoader jdbcLoader = this.getClass().getClassLoader();
    private final CommandLine cmd;

    public ExtractCli(String ... args) throws ExtractCliException {
        this(System.getProperties(), System.getenv(), args);
    }

    public ExtractCli(Properties sysProps, Map<String, String> env, String ... args) throws ExtractCliException {
        BasicParser parser = new BasicParser();
        Options options = this.getOptions();
        File home = this.home(sysProps, env);
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new ExtractCliException(options, e);
        }
        if (this.cmd.getArgs().length == 1) {
            this.inputFile = new File(this.cmd.getArgs()[0]);
            if (!this.inputFile.canRead()) {
                throw new ExtractCliException(options, "Cannot read from input file " + this.inputFile);
            }
        }
        if (this.cmd.getArgs().length > 1) {
            throw new ExtractCliException(options, "Cannot process more than one input file");
        }
        if (this.cmd.hasOption('o')) {
            this.outputFile = new File(this.cmd.getOptionValue('o'));
        }
        if (this.cmd.hasOption('I')) {
            this.inputEncoding = this.cmd.getOptionValue('I');
        }
        if (this.cmd.hasOption('O')) {
            this.outputEncoding = this.cmd.getOptionValue('O');
        }
        if (this.cmd.hasOption('J')) {
            String[] jarNames = this.cmd.getOptionValue('J').split(":");
            URL[] jarPaths = new URL[jarNames.length];
            for (int i = 0; i < jarNames.length; ++i) {
                try {
                    jarPaths[i] = new File(jarNames[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ExtractCliException(options, e);
                }
            }
            this.jdbcLoader = new URLClassLoader(jarPaths, this.getClass().getClassLoader());
        }
        if (this.cmd.hasOption('c')) {
            this.properties = this.loadProperties(options, new File(this.cmd.getOptionValue('c')));
        } else if (home != null) {
            this.properties = this.loadProperties(options, new File(home, "extract.properties"));
        }
        if (this.properties == null) {
            throw new ExtractCliException(options, "You may set the environment variable 'LOGLEVEL' (default 'WARN').\nYou must either set the environment variable 'EXTRACTTOOL_HOME' or the system\nproperty 'extracttool.home'. It should point to a directory containing a file\n'extract.properties'. Alternatively, you can use the '-c' option to provide a\ncustom properties file.");
        }
    }

    private File home(Properties sysProps, Map<String, String> env) {
        String home = sysProps.getProperty("extracttool.home");
        if (home == null) {
            home = env.get("EXTRACTTOOL_HOME");
        }
        if (home == null) {
            return null;
        }
        return new File(home);
    }

    private Properties loadProperties(Options options, File file) throws ExtractCliException {
        if (!file.canRead()) {
            throw new ExtractCliException(options, "Cannot read properties from " + file);
        }
        try {
            Properties properties = new Properties();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            properties.load(reader);
            ((Reader)reader).close();
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("c", "configuration", true, "Properties file overriding the default connection settings");
        options.addOption("I", "input-encoding", true, "input encoding to use (Default: UTF-8)");
        options.addOption("J", "jdbc-jar", true, "load JDBC driver from JAR file");
        options.addOption("O", "output-encoding", true, "output encoding to use (Default: UTF-8)");
        options.addOption("o", true, "write output to given file");
        options.addOption("q", false, "do not report progress");
        options.addOption("z", false, "gzip the output");
        return options;
    }

    public InputStream input() throws IOException {
        if (this.inputFile != null) {
            return new FileInputStream(this.inputFile);
        }
        return System.in;
    }

    public PrintStream output() throws IOException {
        if (this.cmd.hasOption('z')) {
            return new PrintStream(new GZIPOutputStream(this.actualOutput()));
        }
        return this.actualOutput();
    }

    public PrintStream actualOutput() throws IOException {
        if (this.outputFile != null) {
            return new PrintStream(this.outputFile, this.outputEncoding);
        }
        return System.out;
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Reader reader() throws IOException {
        return new InputStreamReader(this.input(), this.inputEncoding);
    }

    @Override
    public Writer writer() throws IOException {
        return new OutputStreamWriter((OutputStream)this.output(), this.outputEncoding);
    }

    @Override
    public File getInputFile() {
        return this.inputFile;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public BackgroundJobMonitor getMonitor() {
        if (this.cmd.hasOption('q')) {
            return new DummyMonitor("egal");
        }
        return new ConsoleProgressMonitor(new PrintWriter(System.err), 50);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    Class<? extends Driver> loadJdbc(String driverClassName) throws ClassNotFoundException {
        Class<Driver> clazz = Class.forName(driverClassName, true, this.jdbcLoader).asSubclass(Driver.class);
        if (clazz == null) {
            throw new ClassNotFoundException("class " + driverClassName + " not found");
        }
        if (!Driver.class.isAssignableFrom(clazz)) {
            throw new ClassNotFoundException("class " + driverClassName + " not a JDBC Driver");
        }
        return clazz;
    }
}

