/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ColumnMapping;
import de.tarent.extract.ResultSetValueExtractor;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.utils.ExtractorException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeaderProcessor {
    private static final Logger LOGGER = LogManager.getLogger(HeaderProcessor.class);
    private final Map<String, ColumnMapping> mappings;
    private final Properties properties;

    public HeaderProcessor(Map<String, ColumnMapping> mappings) {
        this(mappings, null);
    }

    public HeaderProcessor(Map<String, ColumnMapping> mappings, Properties props) {
        this.mappings = mappings;
        this.properties = props;
    }

    @Deprecated
    public ResultSetValueExtractor[] processHeader(ResultSet rs, RowPrinter printer) throws ExtractorException {
        try {
            ResultSetMetaData md = rs.getMetaData();
            return this.processHeader(md, printer);
        }
        catch (Exception e) {
            LOGGER.error(e);
            throw new ExtractorException(e);
        }
    }

    public ResultSetValueExtractor[] processHeader(ResultSetMetaData md, RowPrinter printer) throws ExtractorException {
        ArrayList<ResultSetValueExtractor> extractors = new ArrayList<ResultSetValueExtractor>();
        ArrayList<String> headers = new ArrayList<String>();
        try {
            int n = md.getColumnCount();
            for (int col = 0; col < n; ++col) {
                ColumnMapping mapping = this.mappings.get(md.getColumnLabel(col + 1).toUpperCase());
                if (mapping == null) {
                    extractors.add(null);
                    continue;
                }
                headers.add(mapping.getMapTo());
                extractors.add(this.createValueExtractor(mapping));
            }
            printer.printRow(headers);
            return extractors.toArray(new ResultSetValueExtractor[extractors.size()]);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | SQLException e) {
            throw new ExtractorException(e);
        }
    }

    private ResultSetValueExtractor createValueExtractor(ColumnMapping mapping) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructors;
        Class<? extends ResultSetValueExtractor> clazz = mapping.getExtractWith();
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(Properties.class)) continue;
            return (ResultSetValueExtractor)constructor.newInstance(this.mergeProperties(mapping));
        }
        return clazz.newInstance();
    }

    private Properties mergeProperties(ColumnMapping mapping) {
        Map<String, ?> columnProperties = mapping.getProperties();
        if (columnProperties == null || columnProperties.isEmpty()) {
            return this.properties;
        }
        Properties effectiveProperties = new Properties();
        effectiveProperties.putAll((Map<?, ?>)this.properties);
        effectiveProperties.putAll(columnProperties);
        return effectiveProperties;
    }
}

