package de.tarent.extract;

/*-
 * Extract-Tool is Copyright
 *  © 2015, 2016, 2018 Lukas Degener (l.degener@tarent.de)
 *  © 2018, 2019, 2020 mirabilos (t.glaser@tarent.de)
 *  © 2015 Jens Oberender (j.oberender@tarent.de)
 * Licensor is tarent solutions GmbH, http://www.tarent.de/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import org.apache.commons.csv.CSVFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Properties;

@Configuration
@ComponentScan("de.tarent.extract")
public class SpringConfiguration {
    @Value("${jdbc.url}")
    private String jdbcUrl;
    @Value("${jdbc.driver}")
    private String jdbcDriver;
    @Value("${jdbc.username}")
    private String jdbcUsername;
    @Value("${jdbc.password}")
    private String jdbcPassword;

    @Autowired
    Environment env;

    @Bean
    public Properties jdbcProperties() {
        final Properties properties = new Properties();
        // FIXME: this sucks big time. Any better way to do it?
        // The idea is to get all properties from the environment that start
        // with 'jdbc.' and put them into a Properties object that
        // I can pass along as connection properties to the jdbc driver.
        for (final org.springframework.core.env.PropertySource<?> ps : ((AbstractEnvironment) env)
                .getPropertySources()) {
            if (ps instanceof MapPropertySource) {
                for (final String name : ((MapPropertySource) ps).getPropertyNames()) {
                    final String prefix = "jdbc.";
                    if (name.startsWith(prefix)) {
                        properties.setProperty(name.substring(prefix.length()),
                                env.getProperty(name));
                    }
                }
            }
        }

        return properties;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public DataSource dataSource() throws SQLException {
        final SimpleDriverDataSource ds = new SimpleDriverDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClass(Main.getJdbcDriverClass());
        ds.setUsername(jdbcUsername);
        ds.setPassword(jdbcPassword);

        ds.setConnectionProperties(jdbcProperties());
        return ds;
    }

    @Bean
    JdbcTemplate jdbcTemplate(final DataSource ds) {
        return new JdbcTemplate(ds);
    }

    @Bean
    CSVFormat csvFormat() {
        return CSVFormat.DEFAULT;
    }
}
