/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ExtractorQuery;
import de.tarent.extract.RowFetcher;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.RowProcessor;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.springframework.jdbc.core.JdbcTemplate;

public class DefaultRowFetcher
implements RowFetcher {
    private final JdbcTemplate jdbcTemplate;

    public DefaultRowFetcher(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void fetch(ExtractorQuery query, BackgroundJobMonitor monitor, RowPrinter printer, RowProcessor rowProcessor) {
        String sql = query.getOrderBy() == null ? query.getSql() : query.getSql() + " ORDER BY " + query.getOrderBy();
        this.jdbcTemplate.query(sql, rs -> {
            int rownum = 0;
            while (rs.next()) {
                rowProcessor.processRow(rs, printer);
                if (rownum++ % query.getProgressInterval() != 0) continue;
                monitor.reportProgressAbsolute(rownum);
            }
            monitor.reportProgressAbsolute(rownum);
            return null;
        });
    }
}

