/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.tarent.extract.ColumnMapping;
import de.tarent.extract.CountStrategy;
import de.tarent.extract.DefaultCountStrategy;
import de.tarent.extract.DefaultHeaderProcessorFactory;
import de.tarent.extract.DefaultRowFetcher;
import de.tarent.extract.DefaultRowProcessorFactory;
import de.tarent.extract.ExtractIo;
import de.tarent.extract.ExtractorQuery;
import de.tarent.extract.HeaderProcessor;
import de.tarent.extract.HeaderProcessorFactory;
import de.tarent.extract.RowFetcher;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.RowProcessor;
import de.tarent.extract.RowProcessorFactory;
import de.tarent.extract.utils.ExtractorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.evolvis.tartools.csvfile.CSVFileWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class Extractor {
    private static final Logger LOGGER = LogManager.getLogger(Extractor.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    CountStrategy countStrategy;
    HeaderProcessorFactory headerProcessorFactory = new DefaultHeaderProcessorFactory();
    RowFetcher rowFetcher;
    RowProcessorFactory rowProcessorFactory;

    public Extractor() {
    }

    @Autowired
    public Extractor(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.rowProcessorFactory = new DefaultRowProcessorFactory(jdbcTemplate);
        this.rowFetcher = new DefaultRowFetcher(jdbcTemplate);
        this.countStrategy = new DefaultCountStrategy(jdbcTemplate);
    }

    private ObjectMapper mapper() {
        ObjectMapper mapper;
        try {
            Class<JsonFactory> yaml = Class.forName("com.fasterxml.jackson.dataformat.yaml.YAMLFactory").asSubclass(JsonFactory.class);
            mapper = new ObjectMapper(yaml.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.debug("YAML support not available, using JSON only", (Throwable)e);
            mapper = new ObjectMapper();
        }
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(MapperFeature.AUTO_DETECT_CREATORS, true);
        mapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, true);
        return mapper;
    }

    private ExtractorQuery loadQuery(ExtractIo io) {
        ExtractorQuery descriptor;
        try {
            descriptor = this.mapper().readValue(io.reader(), ExtractorQuery.class);
        }
        catch (JsonParseException e) {
            LOGGER.error("Couldn't parse json", (Throwable)e);
            throw new ExtractorException("Couldn't parse json", e);
        }
        catch (JsonMappingException e) {
            LOGGER.error("Couldn't map json", (Throwable)e);
            throw new ExtractorException("Couldn't map json", e);
        }
        catch (IOException e) {
            LOGGER.error("Could not load configuration", (Throwable)e);
            throw new ExtractorException("Could not load configuration", e);
        }
        return descriptor;
    }

    public void run(ExtractIo io) {
        this.run(io, this.loadQuery(io));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ExtractIo io, ExtractorQuery query) {
        CSVFileWriter csvWriter;
        BackgroundJobMonitor monitor = io.getMonitor();
        try {
            csvWriter = new CSVFileWriter(io.writer());
            csvWriter.setRowSeparator("\r\n");
        }
        catch (IOException e) {
            LOGGER.error("Could not create writer", (Throwable)e);
            throw new ExtractorException("Could not create writer", e);
        }
        RowPrinter printer = csvWriter::writeFields;
        this.normalizeQuery(query);
        try {
            HeaderProcessor headerProcessor = this.headerProcessorFactory.create(query.getMappings(), io.getProperties());
            RowProcessor rowProcessor = this.rowProcessorFactory.create(query.getSql(), printer, headerProcessor);
            Integer total = this.countStrategy.count(query);
            monitor.announceTotal(total);
            monitor.reportProgressAbsolute(0);
            this.rowFetcher.fetch(query, monitor, printer, rowProcessor);
        }
        finally {
            csvWriter.close();
        }
    }

    private void normalizeQuery(ExtractorQuery query) {
        HashMap<String, ColumnMapping> mappings = new HashMap<String, ColumnMapping>();
        for (Map.Entry<String, ColumnMapping> entry : query.getMappings().entrySet()) {
            mappings.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        query.setMappings(mappings);
    }
}

