/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.ExtractCli;
import de.tarent.extract.Extractor;
import de.tarent.extract.SpringConfiguration;
import de.tarent.extract.utils.ExtractCliException;
import java.sql.Driver;
import java.util.Properties;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;

public class Main {
    private static Class<? extends Driver> jdbcDriverClass;

    private Main() {
    }

    public static void main(String[] args) throws ClassNotFoundException {
        try (AnnotationConfigApplicationContext cx = new AnnotationConfigApplicationContext();){
            ExtractCli cli = new ExtractCli(args);
            Main.addPropertySource(cx, cli.getProperties());
            jdbcDriverClass = cli.loadJdbc(cx.getEnvironment().getProperty("jdbc.driver"));
            cx.register(SpringConfiguration.class);
            cx.refresh();
            cx.getBean(Extractor.class).run(cli);
        }
        catch (ExtractCliException e) {
            System.err.println(e.getMessage());
            System.err.println(e.getUsage());
        }
    }

    private static void addPropertySource(AnnotationConfigApplicationContext cx, Properties properties) {
        PropertiesPropertySource ps = new PropertiesPropertySource("defaultProperties", properties);
        cx.getEnvironment().getPropertySources().addFirst(ps);
    }

    public static Class<? extends Driver> getJdbcDriverClass() {
        return jdbcDriverClass;
    }
}

