/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.Main;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

@Configuration
@ComponentScan(value={"de.tarent.extract"})
public class SpringConfiguration {
    @Value(value="${jdbc.url}")
    private String jdbcUrl;
    @Value(value="${jdbc.driver}")
    private String jdbcDriver;
    @Value(value="${jdbc.username}")
    private String jdbcUsername;
    @Value(value="${jdbc.password}")
    private String jdbcPassword;
    @Autowired
    Environment env;

    @Bean
    public Properties jdbcProperties() {
        Properties properties = new Properties();
        for (PropertySource<?> ps : ((AbstractEnvironment)this.env).getPropertySources()) {
            if (!(ps instanceof MapPropertySource)) continue;
            for (String name : ((MapPropertySource)ps).getPropertyNames()) {
                String prefix = "jdbc.";
                if (!name.startsWith("jdbc.")) continue;
                properties.setProperty(name.substring("jdbc.".length()), this.env.getProperty(name));
            }
        }
        return properties;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public DataSource dataSource() {
        SimpleDriverDataSource ds = new SimpleDriverDataSource();
        ds.setUrl(this.jdbcUrl);
        ds.setDriverClass(Main.getJdbcDriverClass());
        ds.setUsername(this.jdbcUsername);
        ds.setPassword(this.jdbcPassword);
        ds.setConnectionProperties(this.jdbcProperties());
        return ds;
    }

    @Bean
    JdbcTemplate jdbcTemplate(DataSource ds) {
        return new JdbcTemplate(ds);
    }
}

