/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.csvfile;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.evolvis.tartools.csvfile.CSVFileWriter;

public class SSVFileWriter
extends CSVFileWriter {
    public SSVFileWriter(String outputFileName) throws IOException {
        this(new FileOutputStream(outputFileName));
    }

    public SSVFileWriter(OutputStream stream) {
        super(stream, '\u001f', '\u0000');
        this.rowSeparator = "\n";
    }

    public SSVFileWriter(Writer writer) {
        super(writer, '\u001f', '\uffff');
        this.rowSeparator = "\n";
    }

    @Override
    public void setRowSeparator(String sep) {
        throw new UnsupportedOperationException("SSV does not allow changing the row separator");
    }

    @Override
    public void setFieldSeparator(char sep) {
        throw new UnsupportedOperationException("SSV does not allow changing the field separator");
    }

    @Override
    public void setTextQualifier(char qual) {
        throw new UnsupportedOperationException("SSV does not have a quote character");
    }

    @Override
    public char getTextQualifier() {
        throw new UnsupportedOperationException("SSV does not have a quote character");
    }

    @Override
    protected String prepareField(Object field) {
        String fieldString;
        String string = fieldString = field == null ? "" : field.toString();
        if (fieldString.indexOf(0) != -1) {
            throw new IllegalArgumentException(String.format("%s (\\x%02X) found in field: %s", "NUL", 0, fieldString));
        }
        if (fieldString.indexOf(31) != -1) {
            throw new IllegalArgumentException(String.format("%s (\\x%02X) found in field: %s", "US", 31, fieldString));
        }
        if (fieldString.indexOf(13) == -1 && fieldString.indexOf(10) == -1) {
            return fieldString;
        }
        return fieldString.replace("\r\n", "\r").replace('\n', '\r');
    }
}

