/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.tarent.extract.ColumnMapping;
import de.tarent.extract.ExtractIo;
import de.tarent.extract.ExtractorQuery;
import de.tarent.extract.HeaderProcessor;
import de.tarent.extract.ResultSetValueExtractor;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.RowProcessor;
import de.tarent.extract.utils.ExtractorException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;

@Component
public class Extractor {
    private static final Logger LOGGER = LogManager.getLogger(Extractor.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    CSVFormat csvFormat = CSVFormat.DEFAULT;

    public Extractor() {
    }

    public Extractor(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(MapperFeature.AUTO_DETECT_CREATORS, true);
        mapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, true);
        return mapper;
    }

    private ExtractorQuery loadQuery(ExtractIo io) {
        ExtractorQuery descriptor;
        try {
            descriptor = this.mapper().readValue(io.reader(), ExtractorQuery.class);
        }
        catch (JsonParseException e) {
            LOGGER.error("Couldn't parse json", (Throwable)e);
            throw new ExtractorException("Couldn't parse json", e);
        }
        catch (JsonMappingException e) {
            LOGGER.error("Couldn't map json", (Throwable)e);
            throw new ExtractorException("Couldn't map json", e);
        }
        catch (IOException e) {
            LOGGER.error("Could not load configuration", (Throwable)e);
            throw new ExtractorException("Could not load configuration", e);
        }
        return descriptor;
    }

    public void run(ExtractIo io) {
        this.run(io, this.loadQuery(io));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final ExtractIo io, final ExtractorQuery query) {
        CSVPrinter csvPrinter;
        final BackgroundJobMonitor monitor = io.getMonitor();
        try {
            csvPrinter = this.csvFormat.print(io.writer());
        }
        catch (IOException e) {
            LOGGER.error("Could not create writer", (Throwable)e);
            throw new ExtractorException("Could not create writer", e);
        }
        final RowPrinter printer = new RowPrinter(){

            @Override
            public void printRow(Iterable<?> values) throws IOException {
                csvPrinter.printRecord(values);
            }
        };
        this.normalizeQuery(query);
        try {
            String countSql = "SELECT COUNT(*) FROM (" + query.getSql() + ") alias42__";
            String sql = "SELECT * FROM (" + query.getSql() + ") alias42__";
            final RowProcessor rowProcessor = this.jdbcTemplate.query(sql + " WHERE 0=1", new ResultSetExtractor<RowProcessor>(){

                @Override
                public RowProcessor extractData(ResultSet rs) throws SQLException, DataAccessException {
                    HeaderProcessor headerProcessor = new HeaderProcessor(query.getMappings(), io.getProperties());
                    ResultSetValueExtractor[] extractors = headerProcessor.processHeader(rs, printer);
                    return new RowProcessor(extractors);
                }
            });
            Integer total = this.jdbcTemplate.queryForObject(countSql, Integer.class);
            monitor.announceTotal(total);
            monitor.reportProgressAbsolute(0);
            this.jdbcTemplate.query(sql, new ResultSetExtractor<Void>(){

                @Override
                public Void extractData(ResultSet rs) throws SQLException, DataAccessException {
                    int rownum = 0;
                    while (rs.next()) {
                        rowProcessor.processRow(rs, printer);
                        if (rownum++ % query.getProgressInterval() != 0) continue;
                        monitor.reportProgressAbsolute(rownum);
                    }
                    monitor.reportProgressAbsolute(rownum);
                    return null;
                }
            });
        }
        finally {
            try {
                csvPrinter.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close csv writer", (Throwable)e);
            }
        }
    }

    private void normalizeQuery(ExtractorQuery query) {
        HashMap<String, ColumnMapping> mappings = new HashMap<String, ColumnMapping>();
        for (Map.Entry<String, ColumnMapping> entry : query.getMappings().entrySet()) {
            mappings.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        query.setMappings(mappings);
    }
}

