package de.tarent.extract;

/*-
 * Extract-Tool is Copyright
 *  © 2015, 2016 Lukas Degener (l.degener@tarent.de)
 *  © 2018 mirabilos (t.glaser@tarent.de)
 *  © 2015 Jens Oberender (j.oberender@tarent.de)
 * Licensor is tarent solutions GmbH, http://www.tarent.de/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import java.util.Map;
import java.util.Properties;

public class ColumnMapping {
    private final Class<? extends ResultSetValueExtractor> extractWith;
    private final String mapTo;
    private final Map<String,?> properties;

    public ColumnMapping() {
        this(null, null);
    }

    public ColumnMapping(final String mapTo) {
        this(mapTo, null);
    }

    public ColumnMapping(final String mapTo, final Class<? extends ResultSetValueExtractor> extractWith) {
        this(mapTo,extractWith,null);
    }

    public ColumnMapping(final String mapTo, final Class<? extends ResultSetValueExtractor> extractWith, Map<String, ?> properties) {
        this.mapTo = mapTo;
        this.properties = properties;
        this.extractWith = extractWith == null ? DefaultExtractor.class : extractWith;

    }

    public Class<? extends ResultSetValueExtractor> getExtractWith() {
        return extractWith;
    }

    public String getMapTo() {
        return mapTo;
    }

    public Map<String, ?> getProperties() {
        return properties;
    }
}
