/*
 * Decompiled with CFR 0.152.
 */
package de.tarent.extract;

import de.tarent.extract.HeaderProcessor;
import de.tarent.extract.ResultSetValueExtractor;
import de.tarent.extract.RowPrinter;
import de.tarent.extract.RowProcessor;
import de.tarent.extract.RowProcessorFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;

public class DefaultRowProcessorFactory
implements RowProcessorFactory {
    private final JdbcTemplate jdbcTemplate;

    public DefaultRowProcessorFactory(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public RowProcessor create(String sql, final RowPrinter printer, final HeaderProcessor headerProcessor) {
        return this.jdbcTemplate.execute(sql, new PreparedStatementCallback<RowProcessor>(){

            @Override
            public RowProcessor doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSetMetaData metaData = ps.getMetaData();
                ResultSetValueExtractor[] extractors = headerProcessor.processHeader(metaData, printer);
                return new RowProcessor(extractors);
            }
        });
    }
}

