/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.backgroundjobs;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import org.evolvis.tartools.backgroundjobs.BackgroundJob;
import org.evolvis.tartools.backgroundjobs.BackgroundJobInfo;
import org.evolvis.tartools.backgroundjobs.BackgroundJobLog;
import org.evolvis.tartools.backgroundjobs.BackgroundJobLogFactory;
import org.evolvis.tartools.backgroundjobs.BackgroundJobMonitor;
import org.evolvis.tartools.backgroundjobs.BackgroundJobStatus;
import org.evolvis.tartools.backgroundjobs.BackgroundThread;
import org.evolvis.tartools.backgroundjobs.BackgroundThreadFactory;
import org.evolvis.tartools.backgroundjobs.FutureFactory;
import org.evolvis.tartools.backgroundjobs.JobEvent;
import org.evolvis.tartools.backgroundjobs.JobListener;
import org.evolvis.tartools.backgroundjobs.ScheduledJob;

public class BackgroundJobScheduler
implements Runnable {
    int jobsToKeep = 5;
    final LinkedHashMap<String, BackgroundJobStatus<?>> scheduledJobs = new LinkedHashMap();
    final LinkedList<String> oldIds = new LinkedList();
    final LinkedBlockingQueue<BackgroundJobStatus<?>> queue = new LinkedBlockingQueue();
    private FutureFactory futureFactory = new FutureFactory(){

        @Override
        public <V> FutureTask<V> createFutureTask(Callable<V> callable) {
            return new FutureTask<V>(callable);
        }
    };
    private BackgroundThreadFactory threadFactory = new BackgroundThreadFactory(){

        @Override
        public BackgroundThread createThread(RunnableFuture<?> f) {
            Thread t = new Thread(f){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BackgroundJobScheduler lock;
                    super.run();
                    BackgroundJobScheduler backgroundJobScheduler = lock = BackgroundJobScheduler.this;
                    synchronized (backgroundJobScheduler) {
                        lock.notifyAll();
                    }
                }
            };
            return new MyThread(t);
        }
    };
    private BackgroundJobLogFactory jobLogFactory = new BackgroundJobLogFactory(){

        @Override
        public BackgroundJobLog createJobLog(final String id) {
            return new BackgroundJobLog(){

                @Override
                public void log(BackgroundJobMonitor.Severity severity, Object message) {
                    System.err.println((Object)((Object)severity) + ":" + id + ": " + message);
                }

                @Override
                public void close() {
                }
            };
        }
    };
    private Thread thread;
    private Object threadLock = new Object();
    private boolean idle = true;

    public BackgroundJobLogFactory getJobLogFactory() {
        return this.jobLogFactory;
    }

    public void setJobLogFactory(BackgroundJobLogFactory jobLogFactory) {
        this.jobLogFactory = jobLogFactory;
    }

    public <T> BackgroundJobStatus<T> schedule(BackgroundJob<T> job) {
        ScheduledJob<T> scheduledJob = new ScheduledJob<T>(job, this.threadFactory, this.futureFactory, this.jobLogFactory);
        this.schedule(scheduledJob);
        return scheduledJob;
    }

    public <T> BackgroundJobStatus<T> schedule(String id, BackgroundJob<T> job) {
        ScheduledJob<T> scheduledJob = new ScheduledJob<T>(id, job, this.threadFactory, this.futureFactory, this.jobLogFactory);
        this.schedule(scheduledJob);
        return scheduledJob;
    }

    @Deprecated
    public <T> BackgroundJobStatus<T> scheduldeImmediately(BackgroundJob<T> job) {
        return this.scheduleImmediately(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BackgroundJobStatus<T> scheduleImmediately(BackgroundJob<T> job) {
        ScheduledJob<T> scheduledJob = null;
        BackgroundJobScheduler backgroundJobScheduler = this;
        synchronized (backgroundJobScheduler) {
            if (this.isIdle()) {
                scheduledJob = new ScheduledJob<T>(job, this.threadFactory, this.futureFactory, this.jobLogFactory);
                this.schedule(scheduledJob);
            }
        }
        return scheduledJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> void schedule(ScheduledJob<T> scheduledJob) {
        scheduledJob.addJobListener(new JobListener(){

            @Override
            public void stateChanged(JobEvent e) {
                BackgroundJobScheduler.this.jobStateChanged(e);
            }

            @Override
            public void progressInfoUpdated(JobEvent e) {
            }
        });
        BackgroundJobScheduler backgroundJobScheduler = this;
        synchronized (backgroundJobScheduler) {
            this.idle = false;
            this.queue.add(scheduledJob);
            this.scheduledJobs.put(scheduledJob.getId(), scheduledJob);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BackgroundJobStatus<?>> getJobs() {
        BackgroundJobScheduler backgroundJobScheduler = this;
        synchronized (backgroundJobScheduler) {
            return this.scheduledJobs.values();
        }
    }

    public synchronized boolean isIdle() {
        return this.idle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStarted() {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread((Runnable)this, "BackgroundJob Scheduler");
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread == null || this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread.join();
            }
            while (!this.queue.isEmpty()) {
                ScheduledJob job = (ScheduledJob)this.queue.take();
                job.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundJobStatus<?> getJob(String id) {
        BackgroundJobScheduler backgroundJobScheduler = this;
        synchronized (backgroundJobScheduler) {
            return this.scheduledJobs.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobStateChanged(JobEvent e) {
        if (e.getOldState() == BackgroundJobInfo.State.SCHEDULED) {
            BackgroundJobScheduler backgroundJobScheduler = this;
            synchronized (backgroundJobScheduler) {
                this.queue.remove(e.getSource());
                this.oldIds.addLast(e.getSource().getId());
                if (this.oldIds.size() > this.jobsToKeep) {
                    String id = this.oldIds.removeFirst();
                    this.scheduledJobs.remove(id);
                }
            }
        }
        if (Arrays.asList(BackgroundJobInfo.State.ABORTED, BackgroundJobInfo.State.FAILED, BackgroundJobInfo.State.SUCCEEDED).contains((Object)e.getNewState())) {
            this.idle = this.queue.isEmpty();
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.executeNext();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized BackgroundJobStatus<?> executeNext() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait(1000L);
        }
        ScheduledJob job = (ScheduledJob)this.queue.take();
        this.idle = false;
        job.execute();
        job.join(0L);
        return job;
    }

    public BackgroundThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(BackgroundThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public FutureFactory getFutureFactory() {
        return this.futureFactory;
    }

    public void setFutureFactory(FutureFactory futureFactory) {
        this.futureFactory = futureFactory;
    }

    public int getJobsToKeep() {
        return this.jobsToKeep;
    }

    public void setJobsToKeep(int jobsToKeep) {
        this.jobsToKeep = jobsToKeep;
    }

    private final class MyThread
    implements BackgroundThread {
        private final Thread t;
        boolean started = false;

        private MyThread(Thread t) {
            this.t = t;
        }

        @Override
        public void start() {
            this.t.start();
            this.started = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void join(long timeout) throws InterruptedException {
            BackgroundJobScheduler backgroundJobScheduler = BackgroundJobScheduler.this;
            synchronized (backgroundJobScheduler) {
                while (this.t.isAlive() || !this.started) {
                    BackgroundJobScheduler.this.wait(100L);
                }
            }
            this.t.join(timeout);
        }
    }
}

