/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.mvnparent;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class InitialiseLogging {
    private static final String EINIT = "could not initialise logging subsystem";
    private static final String ENOTFOUND = "configuration file %s not found";
    private static final String LOGCFG = "logging.properties";
    private static boolean LOG14INITED = false;
    static Logger LOGGER;

    private InitialiseLogging() {
    }

    public static InputStream getResourceAsStream(String filename) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
    }

    public static void InitialiseJDK14Logging() {
        if (LOG14INITED) {
            return;
        }
        InputStream config = InitialiseLogging.getResourceAsStream(LOGCFG);
        IOException exception = null;
        if (config == null) {
            exception = new IOException(String.format(ENOTFOUND, LOGCFG));
        } else {
            try {
                LogManager.getLogManager().readConfiguration(config);
                LOG14INITED = true;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        LOGGER = Logger.getLogger(InitialiseLogging.class.getName());
        if (exception != null) {
            LOGGER.log(Level.SEVERE, EINIT, exception);
        }
    }
}

