/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import org.evolvis.tartools.rfc822.Parser;
import org.evolvis.tartools.rfc822.Path;

public class FQDN
extends Parser {
    public static FQDN of(String hostname) {
        return Parser.of(FQDN.class, hostname);
    }

    protected FQDN(String input) {
        super(input, 254);
    }

    public boolean isDomain() {
        this.jmp(0);
        while (true) {
            int begLabel = this.pos();
            if (!Path.is(this.cur(), (byte)3)) {
                return false;
            }
            while (Path.is(this.peek(), (byte)7)) {
                this.accept();
            }
            if (!Path.is(this.cur(), (byte)3)) {
                return false;
            }
            this.accept();
            if (this.pos() - begLabel > 63) {
                return false;
            }
            if (this.cur() == -1) break;
            if (this.cur() != 46) {
                return false;
            }
            this.accept();
        }
        return true;
    }

    public static boolean isDomain(String hostname) {
        FQDN parser = FQDN.of(hostname);
        return parser != null && parser.isDomain();
    }
}

