/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.evolvis.tartools.rfc822.FQDN;
import org.evolvis.tartools.rfc822.IPAddress;
import org.evolvis.tartools.rfc822.Parser;

public class Path
extends Parser {
    private static final byte F_ALPHA = 1;
    private static final byte F_DIGIT = 2;
    private static final byte F_HYPHN = 4;
    private static final byte F_ATEXT = 8;
    private static final byte F_QTEXT = 16;
    private static final byte F_CTEXT = 32;
    private static final byte F_DTEXT = 64;
    private static final byte F_ABISF = -128;
    static final byte IS_ATEXT = 15;
    static final byte IS_QTEXT = 16;
    static final byte IS_CTEXT = 32;
    static final byte IS_DTEXT = 64;
    static final byte IS_ALNUM = 3;
    static final byte IS_ALNUS = 7;
    static final byte IS_XDIGIT = -126;
    private static final byte[] ASCII;

    protected static boolean is(int c, byte what) {
        if (c < 0 || c >= ASCII.length) {
            return false;
        }
        return (ASCII[c] & what) != 0;
    }

    protected static boolean isAtext(int c) {
        return Path.is(c, (byte)15);
    }

    protected static boolean isCtext(int c) {
        return Path.is(c, (byte)32);
    }

    protected static boolean isDtext(int c) {
        return Path.is(c, (byte)64);
    }

    protected static boolean isQtext(int c) {
        return Path.is(c, (byte)16);
    }

    public static String unfold(String s) {
        int src;
        char[] buf = s.toCharArray();
        int dst = 0;
        block3: for (src = 0; src < buf.length; ++src) {
            switch (buf[src]) {
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    buf[dst++] = buf[src];
                }
            }
        }
        return dst == src ? null : new String(buf, 0, dst);
    }

    protected Parser.Substring unfold(Parser.Substring ss) {
        String u = Path.unfold(ss.toString());
        if (u == null) {
            return ss;
        }
        return new UnfoldedSubstring(ss, u);
    }

    public static Path of(String addresses) {
        return Parser.of(Path.class, addresses);
    }

    protected Path(String input) {
        super(input, 131072);
    }

    public AddressList asMailboxList() {
        this.jmp(0);
        AddressList rv = this.pMailboxList();
        return this.cur() == -1 ? rv : null;
    }

    public Address forSender(boolean allowRFC6854forLimitedUse) {
        this.jmp(0);
        Address rv = allowRFC6854forLimitedUse ? this.pAddress() : this.pMailbox();
        return this.cur() == -1 ? rv : null;
    }

    public AddrSpec asAddrSpec() {
        this.jmp(0);
        AddrSpec rv = this.pAddrSpec();
        return this.cur() == -1 ? rv : null;
    }

    public AddressList asAddressList() {
        this.jmp(0);
        AddressList rv = this.pAddressList();
        return this.cur() == -1 ? rv : null;
    }

    protected AddressList pAddressList() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            Address a = this.pAddress();
            if (a == null) {
                AddressList addressList = null;
                return addressList;
            }
            ofs.commit();
            ArrayList<Address> rv = new ArrayList<Address>();
            rv.add(a);
            while (this.cur() == 44) {
                this.accept();
                Address a2 = this.pAddress();
                if (a2 == null) break;
                ofs.commit();
                rv.add(a2);
            }
            AddressList addressList = new AddressList(rv);
            return addressList;
        }
    }

    protected AddressList pMailboxList() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            Address m = this.pMailbox();
            if (m == null) {
                AddressList addressList = null;
                return addressList;
            }
            ofs.commit();
            ArrayList<Address> rv = new ArrayList<Address>();
            rv.add(m);
            while (this.cur() == 44) {
                this.accept();
                Address m2 = this.pMailbox();
                if (m2 == null) break;
                ofs.commit();
                rv.add(m2);
            }
            AddressList addressList = new AddressList(rv);
            return addressList;
        }
    }

    protected Address pAddress() {
        Address rv = this.pMailbox();
        if (rv != null) {
            return rv;
        }
        rv = this.pGroup();
        if (rv != null) {
            return rv;
        }
        return null;
    }

    protected Address pGroup() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            List<Object> gl;
            Parser.Substring dn = this.pDisplayName();
            if (dn == null) {
                Address address = null;
                return address;
            }
            if (this.cur() != 58) {
                Address address = null;
                return address;
            }
            this.accept();
            AddressList ml = this.pMailboxList();
            if (ml == null) {
                this.pCFWS();
            }
            List<Object> list = gl = ml == null ? new ArrayList() : ml.addresses;
            if (this.cur() != 59) {
                Address address = null;
                return address;
            }
            this.accept();
            this.pCFWS();
            Address address = ofs.accept(new Address(dn, gl));
            return address;
        }
    }

    protected Address pMailbox() {
        Address na = this.pNameAddr();
        if (na != null) {
            return na;
        }
        AddrSpec as = this.pAddrSpec();
        if (as != null) {
            return new Address(null, as);
        }
        return null;
    }

    protected Address pNameAddr() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            Parser.Substring dn = this.pDisplayName();
            AddrSpec aa = this.pAngleAddr();
            if (aa == null) {
                Address address = null;
                return address;
            }
            Address address = ofs.accept(new Address(dn, aa));
            return address;
        }
    }

    protected AddrSpec pAngleAddr() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            this.pCFWS();
            if (this.cur() != 60) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            this.accept();
            AddrSpec as = this.pAddrSpec();
            if (as == null) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            if (this.cur() != 62) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            this.accept();
            this.pCFWS();
            AddrSpec addrSpec = ofs.accept(as);
            return addrSpec;
        }
    }

    protected Parser.Substring pDisplayName() {
        return this.pPhrase();
    }

    protected Parser.Substring pPhrase() {
        int lpos;
        int beg = this.pos();
        this.pCFWS();
        int ofs = this.pos();
        Word w = this.pWord();
        if (w == null) {
            this.jmp(beg);
            return null;
        }
        StringBuilder d = new StringBuilder();
        do {
            d.append(w.body.getData() == null ? w.body.toString() : (String)w.body.getData());
            lpos = w.body.end;
            Parser.Substring wsp = w.cfws;
            w = this.pWord();
            if (w == null || wsp == null) continue;
            d.append(this.unfold(wsp).toString());
        } while (w != null);
        return this.unfold(new Parser.Substring(this, ofs, lpos, d.toString()));
    }

    protected Word pWord() {
        Word rv = this.pAtom();
        if (rv != null) {
            return rv;
        }
        rv = this.pQuotedString();
        if (rv != null) {
            return rv;
        }
        return null;
    }

    protected Word pAtom() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            this.pCFWS();
            if (!Path.isAtext(this.cur())) {
                Word word = null;
                return word;
            }
            ofs.commit();
            this.skip(Path::isAtext);
            Parser.Substring atom = ofs.substring();
            Parser.Substring wsp = this.pCFWS();
            Word word = ofs.accept(new Word(atom, wsp));
            return word;
        }
    }

    protected int pQuotedPair() {
        int c;
        if (this.cur() == 92 && ((c = this.peek()) >= 32 && c <= 126 || c == 9)) {
            this.bra(2);
            return c;
        }
        return -1;
    }

    protected int pQcontent() {
        int c = this.cur();
        if (Path.isQtext(c)) {
            this.accept();
            return c;
        }
        return this.pQuotedPair();
    }

    protected Word pQuotedString() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            Parser.Substring wsp;
            this.pCFWS();
            if (this.cur() != 34) {
                Word word = null;
                return word;
            }
            int content = this.pos();
            this.accept();
            StringBuilder rv = new StringBuilder();
            while (true) {
                int qc;
                if ((wsp = this.pFWS()) != null) {
                    rv.append(this.unfold(wsp).toString());
                }
                if ((qc = this.pQcontent()) == -1) break;
                rv.append(qc);
            }
            if (this.cur() != 34) {
                wsp = null;
                return wsp;
            }
            this.accept();
            Parser.Substring qs = this.unfold(new Parser.Substring(this, content, this.pos(), rv.toString()));
            Parser.Substring wsp2 = this.pCFWS();
            Word word = ofs.accept(new Word(qs, wsp2));
            return word;
        }
    }

    static boolean isWSP(int cur) {
        return cur == 32 || cur == 9;
    }

    protected Parser.Substring pFWS() {
        int beg = this.pos();
        Parser.Substring w = null;
        int c = this.cur();
        if (Path.isWSP(c)) {
            c = this.skip(Path::isWSP);
            w = new Parser.Substring((Parser)this, beg, this.pos());
        }
        if (c != 13 && c != 10) {
            return w;
        }
        int c2 = this.peek();
        if (c == 13 && c2 == 10) {
            if (!Path.isWSP(this.bra(2))) {
                this.bra(-2);
                return w;
            }
        } else {
            if (!Path.isWSP(c2)) {
                return w;
            }
            this.accept();
        }
        this.skip(Path::isWSP);
        return new Parser.Substring((Parser)this, beg, this.pos());
    }

    protected boolean pCcontent() {
        if (Path.isCtext(this.cur())) {
            this.accept();
            return true;
        }
        return this.pQuotedPair() != -1 || this.pComment() != null;
    }

    protected Parser.Substring pComment() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            if (this.cur() != 40) {
                Parser.Substring substring = null;
                return substring;
            }
            this.accept();
            do {
                this.pFWS();
            } while (this.pCcontent());
            if (this.cur() != 41) {
                Parser.Substring substring = null;
                return substring;
            }
            this.accept();
            Parser.Substring substring = ofs.accept(ofs.substring());
            return substring;
        }
    }

    protected Parser.Substring pCFWS() {
        int beg = this.pos();
        Parser.Substring wsp = this.pFWS();
        if (this.pComment() == null) {
            return wsp;
        }
        do {
            this.pFWS();
        } while (this.pComment() != null);
        return new Parser.Substring((Parser)this, beg, this.pos());
    }

    protected Parser.Substring pDotAtom() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            int c;
            this.pCFWS();
            if (!Path.isAtext(this.cur())) {
                Parser.Substring substring = null;
                return substring;
            }
            ofs.commit();
            do {
                this.accept();
            } while ((c = this.skip(Path::isAtext)) == 46 && Path.isAtext(this.peek()));
            Parser.Substring rv = ofs.substring();
            this.pCFWS();
            Parser.Substring substring = ofs.accept(rv);
            return substring;
        }
    }

    protected AddrSpecSIDE pLocalPart() {
        Word qs;
        Parser.Substring da = this.pDotAtom();
        Word word = qs = da == null ? this.pQuotedString() : null;
        if (da == null && qs == null) {
            return null;
        }
        Parser.Substring ss = da == null ? qs.body : da;
        String us = ss.toString();
        boolean v = us.length() <= 64 && us.indexOf(9) == -1;
        return new AddrSpecSIDE(ss, us, v);
    }

    protected Parser.Substring pDomainLiteral() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            this.pCFWS();
            if (this.cur() != 91) {
                Parser.Substring substring = null;
                return substring;
            }
            int content = this.pos();
            this.accept();
            this.pFWS();
            while (Path.isDtext(this.cur())) {
                this.accept();
                this.pFWS();
            }
            if (this.cur() != 93) {
                Parser.Substring substring = null;
                return substring;
            }
            this.accept();
            Parser.Substring rv = new Parser.Substring((Parser)this, content, this.pos());
            this.pCFWS();
            Parser.Substring substring = ofs.accept(rv);
            return substring;
        }
    }

    protected Parser.Substring pDomain() {
        InetAddress v;
        String us;
        Parser.Substring da = this.pDotAtom();
        if (da != null) {
            String us2 = da.toString();
            boolean v2 = FQDN.isDomain(us2);
            return new AddrSpecSIDE(da, us2, v2);
        }
        Parser.Substring dl = this.pDomainLiteral();
        if (dl == null) {
            return null;
        }
        String dls = dl.toString();
        String dlu = Path.unfold(dls);
        String string = us = dlu == null ? dls : dlu;
        if (us.toLowerCase(Locale.ROOT).startsWith("[ipv6:")) {
            String addr = us.substring(6, us.length() - 1);
            v = IPAddress.v6(addr);
        } else {
            String addr = us.substring(1, us.length() - 1);
            v = IPAddress.v4(addr);
        }
        return new UnfoldedSubstring(dl, us, v);
    }

    protected AddrSpec pAddrSpec() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            AddrSpecSIDE lp = this.pLocalPart();
            if (lp == null) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            if (this.cur() != 64) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            this.accept();
            Parser.Substring dom = this.pDomain();
            if (dom == null) {
                AddrSpec addrSpec = null;
                return addrSpec;
            }
            boolean v = lp.isValid() && (dom instanceof AddrSpecSIDE ? ((AddrSpecSIDE)dom).isValid() : dom.getData() != null) && lp.toString().length() + 1 + dom.toString().length() <= 254;
            AddrSpec addrSpec = ofs.accept(new AddrSpec(lp, dom, v));
            return addrSpec;
        }
    }

    static {
        int c;
        ASCII = new byte[128];
        Arrays.fill(ASCII, (byte)0);
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            int n = c;
            ASCII[n] = (byte)(ASCII[n] | 1);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            int n = c;
            ASCII[n] = (byte)(ASCII[n] | 1);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            int n = c;
            ASCII[n] = (byte)(ASCII[n] | 2);
        }
        ASCII[45] = (byte)(ASCII[45] | 4);
        ASCII[33] = (byte)(ASCII[33] | 8);
        ASCII[35] = (byte)(ASCII[35] | 8);
        ASCII[36] = (byte)(ASCII[36] | 8);
        ASCII[37] = (byte)(ASCII[37] | 8);
        ASCII[38] = (byte)(ASCII[38] | 8);
        ASCII[39] = (byte)(ASCII[39] | 8);
        ASCII[42] = (byte)(ASCII[42] | 8);
        ASCII[43] = (byte)(ASCII[43] | 8);
        ASCII[47] = (byte)(ASCII[47] | 8);
        ASCII[61] = (byte)(ASCII[61] | 8);
        ASCII[63] = (byte)(ASCII[63] | 8);
        ASCII[94] = (byte)(ASCII[94] | 8);
        ASCII[95] = (byte)(ASCII[95] | 8);
        ASCII[96] = (byte)(ASCII[96] | 8);
        ASCII[123] = (byte)(ASCII[123] | 8);
        ASCII[124] = (byte)(ASCII[124] | 8);
        ASCII[125] = (byte)(ASCII[125] | 8);
        ASCII[126] = (byte)(ASCII[126] | 8);
        ASCII[65] = (byte)(ASCII[65] | 0xFFFFFF80);
        ASCII[66] = (byte)(ASCII[66] | 0xFFFFFF80);
        ASCII[67] = (byte)(ASCII[67] | 0xFFFFFF80);
        ASCII[68] = (byte)(ASCII[68] | 0xFFFFFF80);
        ASCII[69] = (byte)(ASCII[69] | 0xFFFFFF80);
        ASCII[70] = (byte)(ASCII[70] | 0xFFFFFF80);
        ASCII[97] = (byte)(ASCII[97] | 0xFFFFFF80);
        ASCII[98] = (byte)(ASCII[98] | 0xFFFFFF80);
        ASCII[99] = (byte)(ASCII[99] | 0xFFFFFF80);
        ASCII[100] = (byte)(ASCII[100] | 0xFFFFFF80);
        ASCII[101] = (byte)(ASCII[101] | 0xFFFFFF80);
        ASCII[102] = (byte)(ASCII[102] | 0xFFFFFF80);
        ASCII[33] = (byte)(ASCII[33] | 0x10);
        int d = 35;
        while (d <= 91) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x10);
        }
        d = 33;
        while (d <= 39) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x20);
        }
        d = 42;
        while (d <= 91) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x20);
        }
        d = 93;
        while (d <= 126) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x30);
        }
        d = 33;
        while (d <= 90) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x40);
        }
        d = 94;
        while (d <= 126) {
            int n = d++;
            ASCII[n] = (byte)(ASCII[n] | 0x40);
        }
    }

    public final class AddressList
    implements ParserResult {
        final List<Address> addresses;
        final boolean valid;
        final boolean addressList;

        private AddressList(List<Address> addresses) {
            this.addresses = addresses;
            this.valid = addresses.stream().allMatch(Address::isValid);
            this.addressList = addresses.stream().anyMatch(Address::isGroup);
        }

        @Override
        public String toString() {
            return this.addresses.stream().map(Address::toString).collect(Collectors.joining(", "));
        }

        public String invalidsToString() {
            if (this.valid) {
                return null;
            }
            return this.addresses.stream().filter(((Predicate<Address>)Address::isValid).negate()).map(Address::toString).collect(Collectors.joining(", "));
        }

        public List<String> flattenAddresses() {
            return this.addresses.stream().map(Address::toString).collect(Collectors.toList());
        }

        public List<String> flattenAddrSpecs() {
            ArrayList<String> rv = new ArrayList<String>();
            for (Address address : this.addresses) {
                if (address.isGroup()) {
                    for (Address mailbox : address.mailboxen) {
                        rv.add(mailbox.mailbox.toString());
                    }
                    continue;
                }
                rv.add(address.mailbox.toString());
            }
            return rv;
        }

        @Generated
        public List<Address> getAddresses() {
            return this.addresses;
        }

        @Override
        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public boolean isAddressList() {
            return this.addressList;
        }
    }

    public final class Address
    implements ParserResult {
        final boolean group;
        final Parser.Substring label;
        final AddrSpec mailbox;
        final List<Address> mailboxen;
        final boolean valid;

        private Address(Parser.Substring label, AddrSpec mailbox) {
            this.group = false;
            this.label = label;
            this.mailbox = mailbox;
            this.mailboxen = null;
            this.valid = mailbox.isValid();
        }

        private Address(Parser.Substring label, List<Address> mailboxen) {
            this.group = true;
            this.label = label;
            this.mailbox = null;
            this.mailboxen = mailboxen;
            this.valid = mailboxen.stream().allMatch(Address::isValid);
        }

        @Override
        public String toString() {
            if (!this.group) {
                return this.label == null ? this.mailbox.toString() : String.format("%s <%s>", this.label, this.mailbox);
            }
            return String.format("%s:%s;", this.label, this.mailboxen.stream().map(Address::toString).collect(Collectors.joining(",")));
        }

        @Generated
        public boolean isGroup() {
            return this.group;
        }

        @Generated
        public Parser.Substring getLabel() {
            return this.label;
        }

        @Generated
        public AddrSpec getMailbox() {
            return this.mailbox;
        }

        @Generated
        public List<Address> getMailboxen() {
            return this.mailboxen;
        }

        @Override
        @Generated
        public boolean isValid() {
            return this.valid;
        }
    }

    public final class AddrSpec
    implements ParserResult {
        @NonNull
        final Parser.Substring localPart;
        @NonNull
        final Parser.Substring domain;
        final boolean valid;

        @Override
        public String toString() {
            return this.localPart + "@" + this.domain;
        }

        @Generated
        protected AddrSpec(@NonNull Parser.Substring localPart, Parser.Substring domain, boolean valid) {
            if (localPart == null) {
                throw new NullPointerException("localPart is marked non-null but is null");
            }
            if (domain == null) {
                throw new NullPointerException("domain is marked non-null but is null");
            }
            this.localPart = localPart;
            this.domain = domain;
            this.valid = valid;
        }

        @NonNull
        @Generated
        public Parser.Substring getLocalPart() {
            return this.localPart;
        }

        @NonNull
        @Generated
        public Parser.Substring getDomain() {
            return this.domain;
        }

        @Override
        @Generated
        public boolean isValid() {
            return this.valid;
        }
    }

    public static interface ParserResult {
        public boolean isValid();

        public String toString();
    }

    private static final class Word {
        protected final Parser.Substring body;
        protected final Parser.Substring cfws;

        @Generated
        public Word(Parser.Substring body, Parser.Substring cfws) {
            this.body = body;
            this.cfws = cfws;
        }
    }

    protected class AddrSpecSIDE
    extends Parser.Substring {
        private final boolean valid;

        private AddrSpecSIDE(Parser.Substring src, String us, boolean v) {
            super((Parser)Path.this, src, us);
            this.valid = v;
        }

        @Override
        public String toString() {
            return (String)this.getData();
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }
    }

    protected class UnfoldedSubstring
    extends Parser.Substring {
        private final String string;

        private UnfoldedSubstring(Parser.Substring ss, String us) {
            super(Path.this, ss);
            this.string = us;
        }

        private UnfoldedSubstring(Parser.Substring ss, String us, Object data) {
            super((Parser)Path.this, ss, data);
            this.string = us;
        }

        @Override
        public String toString() {
            return this.string;
        }
    }
}

