/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import java.lang.reflect.Constructor;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

abstract class Parser {
    static final String BOUNDS_JMP = "attempt to move (%d) beyond source string (%d)";
    static final String ACCEPT_EOS = "cannot ACCEPT end of input";
    private final String source;
    private int ofs;
    private int cur;
    private int succ;
    private int next;
    private final int srcsz;

    protected Parser(String input, int maxlen) {
        int n = this.srcsz = input == null ? -1 : input.length();
        if (this.srcsz < 0 || this.srcsz > maxlen) {
            this.source = null;
        } else {
            this.source = input;
            this.jmp(0);
        }
    }

    protected static <T extends Parser> T of(Class<T> cls, String input) {
        try {
            Constructor<T> creator = cls.getDeclaredConstructor(String.class);
            Parser obj = (Parser)creator.newInstance(input);
            return (T)(obj.s() == null ? null : obj);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    protected final int jmp(int pos) {
        if (pos < 0 || pos > this.srcsz) {
            throw new IndexOutOfBoundsException(String.format(BOUNDS_JMP, pos, this.srcsz));
        }
        this.ofs = pos;
        if (this.ofs == this.srcsz) {
            this.succ = this.ofs;
            this.cur = -1;
            this.next = -1;
            return this.cur;
        }
        this.cur = this.source.codePointAt(this.ofs);
        this.succ = this.ofs + Character.charCount(this.cur);
        this.next = this.succ < this.srcsz ? this.source.codePointAt(this.succ) : -1;
        return this.cur;
    }

    protected final int bra(int deltapos) {
        return this.jmp(this.ofs + deltapos);
    }

    protected final int pos() {
        return this.ofs;
    }

    protected final String s() {
        return this.source;
    }

    protected final int cur() {
        return this.cur;
    }

    protected final int peek() {
        return this.next;
    }

    protected final int accept() {
        if (this.cur == -1) {
            throw new IndexOutOfBoundsException(ACCEPT_EOS);
        }
        return this.jmp(this.succ);
    }

    protected final int skipPeek(BiFunction<Integer, Integer, Boolean> matcher) {
        while (this.cur != -1 && matcher.apply(this.cur, this.next).booleanValue()) {
            this.jmp(this.succ);
        }
        return this.cur;
    }

    protected final int skip(Function<Integer, Boolean> matcher) {
        while (this.cur != -1 && matcher.apply(this.cur).booleanValue()) {
            this.jmp(this.succ);
        }
        return this.cur;
    }

    final class Txn
    implements AutoCloseable {
        private int pos;

        protected Txn() {
            this.commit();
        }

        final int savepoint() {
            return this.pos;
        }

        final void commit() {
            this.pos = Parser.this.ofs;
        }

        final int rollback() {
            return Parser.this.jmp(this.savepoint());
        }

        @Override
        public final void close() {
            this.rollback();
        }

        final <T> T accept(T returnValue) {
            this.commit();
            return returnValue;
        }

        final Substring substring() {
            return new Substring(this.savepoint(), Parser.this.ofs);
        }

        final Substring substring(Object data) {
            return new Substring(this.savepoint(), Parser.this.ofs, data);
        }
    }

    protected class Substring {
        protected final int beg;
        protected final int end;
        private final Object data;

        protected Substring(int beg, int end) {
            this(beg, end, null);
        }

        protected Substring(Substring src) {
            this(src.beg, src.end, src.data);
        }

        protected Substring(Substring src, Object data) {
            this(src.beg, src.end, data);
        }

        protected Substring(int beg, int end, Object data) {
            assert (end >= beg) : "end after beginning";
            assert (beg >= 0) : "negative beginning";
            assert (end <= Parser.this.srcsz) : "past end of input";
            this.beg = beg;
            this.end = end;
            this.data = data;
        }

        public String toString() {
            return Parser.this.s().substring(this.beg, this.end);
        }

        @Generated
        public Object getData() {
            return this.data;
        }
    }
}

