/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import java.net.InetAddress;
import org.evolvis.tartools.rfc822.FQDN;
import org.evolvis.tartools.rfc822.IPAddress;
import org.evolvis.tartools.rfc822.Path;

public final class CLI {
    private static final String EAS = "addr-spec %s  ";
    private static final String EML = "mailbox-list %s  address-list %s";
    private static final String EMA = " list) mailbox %s  address %s";
    private static final String DIP = "  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String ISLIST = "addr-spec %s  mailbox-list %s  address-list %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String NOLIST = "addr-spec %s  (no list) mailbox %s  address %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String ORLIST = "addr-spec %s  (or list) mailbox %s  address %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String CLR = "\u001b[0m";
    private static final String BAD = "\u001b[31m\u2718\u001b[0m";
    private static final String PARSES = "\u001b[1;33m\u2718\u001b[0m";
    private static final String VALID = "\u001b[32m\u2714\u001b[0m";
    private static final String BOLD = "\u001b[1m";

    private static String chk(Path.ParserResult arg) {
        return arg == null ? BAD : (arg.isValid() ? VALID : PARSES);
    }

    private static void one(Path.ParserResult arg) {
        if (arg == null) {
            System.exit(41);
        }
        if (!arg.isValid()) {
            System.exit(42);
        }
        System.out.println(arg);
        System.exit(0);
    }

    private static void usage() {
        System.err.println("Usage: java -jar rfc822.jar -TYPE input  # check mode (on success, exit 0)");
        System.err.println("       java -jar rfc822.jar [input ...]  # interactive colourful mode, exit 40");
        System.err.println("TYPE: addrspec, mailbox, address, mailboxlist, addresslist, domain, ipv4, ipv6");
        System.err.println("exit code 43 = unspecified bad input, 42 = invalid, 41 = cannot even be parsed");
        System.exit(1);
    }

    private static void batch(String flag, String input) {
        if ("-addrspec".equals(flag)) {
            Path asPath = Path.of(input);
            CLI.one(asPath.asAddrSpec());
        } else if ("-mailbox".equals(flag)) {
            Path asPath = Path.of(input);
            CLI.one(asPath.forSender(false));
        } else if ("-address".equals(flag)) {
            Path asPath = Path.of(input);
            CLI.one(asPath.forSender(true));
        } else if ("-mailboxlist".equals(flag)) {
            Path asPath = Path.of(input);
            CLI.one(asPath.asMailboxList());
        } else if ("-addresslist".equals(flag)) {
            Path asPath = Path.of(input);
            CLI.one(asPath.asAddressList());
        } else if ("-domain".equals(flag)) {
            String asDomain = FQDN.asDomain(input);
            if (asDomain == null) {
                System.exit(43);
            }
            System.out.println(asDomain);
            System.exit(0);
        } else if ("-ipv4".equals(flag)) {
            InetAddress i4 = IPAddress.v4(input);
            if (i4 == null) {
                System.exit(43);
            }
            System.out.println(i4.getHostAddress());
            System.exit(0);
        } else if ("-ipv6".equals(flag)) {
            InetAddress i6 = IPAddress.v6(input);
            if (i6 == null) {
                System.exit(43);
            }
            System.out.println(i6.getHostAddress());
            System.exit(0);
        }
        CLI.usage();
    }

    public static void main(String[] argv) {
        boolean skipfirst = false;
        if (argv.length > 0 && argv[0].startsWith("-")) {
            if ("--".equals(argv[0])) {
                skipfirst = true;
            } else if (argv.length == 2) {
                CLI.batch(argv[0], argv[1]);
            } else if (argv.length == 3 && "--".equals(argv[1])) {
                CLI.batch(argv[0], argv[2]);
            } else {
                CLI.usage();
            }
        }
        System.out.println(CLR);
        for (String arg : argv) {
            Path.ParserResult rmail;
            String dadr;
            String dmbx;
            String desc;
            if (skipfirst) {
                skipfirst = false;
                continue;
            }
            Path asPath = Path.of(arg);
            Path.AddrSpec asAS = asPath.asAddrSpec();
            Path.Address asMbox = asPath.forSender(false);
            Path.Address asAddr = asPath.forSender(true);
            Path.AddressList asML = asPath.asMailboxList();
            Path.AddressList asAL = asPath.asAddressList();
            String isDom = FQDN.asDomain(arg);
            InetAddress i6 = IPAddress.v6(arg);
            InetAddress i4 = IPAddress.v4(arg);
            if (asMbox != null || asAddr != null || asML == null && asAL == null) {
                desc = asML == null && asAL == null ? NOLIST : ORLIST;
                dmbx = CLI.chk(asMbox);
                dadr = CLI.chk(asAddr);
                rmail = asAddr == null ? asMbox : asAddr;
            } else {
                desc = ISLIST;
                dmbx = CLI.chk(asML);
                dadr = CLI.chk(asAL);
                rmail = asAL == null ? asML : asAL;
            }
            System.out.printf("\u2023 %s\u001b[0m%n\t", arg);
            System.out.printf(desc + "%n", CLI.chk(asAS), dmbx, dadr, isDom != null ? VALID : BAD, i6 == null ? BAD : VALID, i4 == null ? BAD : VALID);
            if (rmail != null && rmail.isValid()) {
                System.out.printf("\teMail: \u001b[1m%s\u001b[0m%n", rmail);
            }
            if (i6 != null || i4 != null) {
                System.out.printf("\tIP: \u001b[1m%s\u001b[0m%n", (i6 == null ? i4 : i6).getHostAddress());
            }
            if (isDom != null) {
                System.out.printf("\tFQDN: \u001b[1m%s\u001b[0m%n", isDom);
            }
            System.out.println();
        }
        System.exit(40);
    }
}

