/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Locale;
import org.evolvis.tartools.rfc822.FQDN;
import org.evolvis.tartools.rfc822.IPAddress;
import org.evolvis.tartools.rfc822.MiscUtils;
import org.evolvis.tartools.rfc822.Path;
import org.evolvis.tartools.rfc822.UXAddress;

public final class CLI {
    private static final String EAS = "addr-spec %s  ";
    private static final String EML = "mailbox-list %s  address-list %s";
    private static final String EMA = " list) mailbox %s  address %s";
    private static final String DIP = "  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String ISLIST = "addr-spec %s  mailbox-list %s  address-list %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String NOLIST = "addr-spec %s  (no list) mailbox %s  address %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String ORLIST = "addr-spec %s  (or list) mailbox %s  address %s  FQDN %s  IPv6 %s  IPv4 %s";
    private static final String CLR = "\u001b[0m";
    private static final String BAD = "\u001b[31m\u2718\u001b[0m";
    private static final String PARSES = "\u001b[1;33m\u2718\u001b[0m";
    private static final String VALID = "\u001b[32m\u2714\u001b[0m";
    private static final String BOLD = "\u001b[1m";
    private static final String INVERSE = "\u001b[7m";
    private static final String PROMPT = "\u001b[0m\r\u001b[7mrfc822>\u001b[0m ";
    private static boolean lax = false;

    private static String chk(Path.ParserResult arg) {
        return arg == null ? BAD : (arg.isValid() ? VALID : PARSES);
    }

    private static void one(Path.ParserResult arg) {
        if (arg == null) {
            System.exit(41);
        }
        if (!arg.isValid()) {
            System.exit(42);
        }
        System.out.println(arg);
        System.exit(0);
    }

    private static void usage() {
        System.err.println("Usage: java -jar rfc822.jar [input ...]  # interactive colourful mode, exit 40");
        System.err.println("       java -jar rfc822.jar -TYPE input  # check mode (on success, exit 0)");
        System.err.println("TYPE: addrspec, mailbox, address, mailboxlist, addresslist, domain, ipv4, ipv6");
        System.err.println("exit code 43 = unspecified bad input, 42 = invalid, 41 = cannot even be parsed");
        System.err.println("       java -jar rfc822.jar -extract input ...  # list addr-spec of each input");
        System.err.println("exit code 45 = no valid input, 0 = all inputs valid, 44 = some invalid present");
        System.err.println("Extra options (pass before others): -lax use user-friendly parsing, trim input");
        System.exit(1);
    }

    private static String canonicaliseParsedFQDN(String s) {
        return s == null ? null : s.toLowerCase(Locale.ROOT);
    }

    private static String prepareArg(String arg) {
        if (arg == null || !lax) {
            return arg;
        }
        return MiscUtils.trim(arg);
    }

    private static void batch(String flag, String input) {
        if ("-addrspec".equals(flag) || "-addr-spec".equals(flag)) {
            Path asPath = lax ? UXAddress.of(input) : Path.of(input);
            CLI.one(asPath != null ? asPath.asAddrSpec() : null);
        } else if ("-mailbox".equals(flag)) {
            Path asPath = lax ? UXAddress.of(input) : Path.of(input);
            CLI.one(asPath != null ? asPath.forSender(false) : null);
        } else if ("-address".equals(flag)) {
            Path asPath = lax ? UXAddress.of(input) : Path.of(input);
            CLI.one(asPath != null ? asPath.forSender(true) : null);
        } else if ("-mailboxlist".equals(flag) || "-mailbox-list".equals(flag)) {
            Path asPath = lax ? UXAddress.of(input) : Path.of(input);
            CLI.one(asPath != null ? asPath.asMailboxList() : null);
        } else if ("-addresslist".equals(flag) || "-address-list".equals(flag)) {
            Path asPath = lax ? UXAddress.of(input) : Path.of(input);
            CLI.one(asPath != null ? asPath.asAddressList() : null);
        } else if ("-domain".equals(flag) || "-fqdn".equals(flag)) {
            String asDomain = CLI.canonicaliseParsedFQDN(FQDN.asDomain(input));
            if (asDomain == null) {
                System.exit(43);
            }
            System.out.println(asDomain);
            System.exit(0);
        } else if ("-ipv4".equals(flag)) {
            InetAddress i4 = IPAddress.v4(input);
            if (i4 == null) {
                System.exit(43);
            }
            System.out.println(i4.getHostAddress());
            System.exit(0);
        } else if ("-ipv6".equals(flag)) {
            InetAddress i6 = IPAddress.v6(input);
            if (i6 == null) {
                System.exit(43);
            }
            System.out.println(i6.getHostAddress());
            System.exit(0);
        }
        CLI.usage();
    }

    private static void extract(String[] args, int skip) {
        boolean anyValid = false;
        boolean anyInvalid = false;
        for (String el : args) {
            Path.AddressList l;
            if (skip > 0) {
                --skip;
                continue;
            }
            String arg = CLI.prepareArg(el);
            Path p = lax ? UXAddress.of(arg) : Path.of(arg);
            Path.AddressList addressList = l = p != null ? p.asAddressList() : null;
            if (l != null && l.isValid()) {
                System.out.println(String.join((CharSequence)", ", l.flattenAddrSpecs()));
                anyValid = true;
                continue;
            }
            System.err.println("N: not valid: " + MiscUtils.escapeNonPrintASCII(arg));
            System.out.println();
            anyInvalid = true;
        }
        if (!anyValid) {
            System.err.println("E: no valid inputs provided");
            System.exit(45);
        }
        if (!anyInvalid) {
            System.exit(0);
        }
        System.err.println("E: there were some invalid inputs");
        System.exit(44);
    }

    public static void main(String[] argv) throws IOException {
        int optind = 0;
        int argc = argv.length;
        while (argc > 0 && argv[optind].startsWith("-")) {
            if ("--".equals(argv[optind])) {
                ++optind;
                --argc;
                break;
            }
            if ("-lax".equals(argv[optind])) {
                ++optind;
                --argc;
                lax = true;
                continue;
            }
            if ("-extract".equals(argv[optind])) {
                if (--argc > 0 && "--".equals(argv[++optind])) {
                    ++optind;
                    --argc;
                }
                if (argc <= 0) continue;
                CLI.extract(argv, optind);
                continue;
            }
            if (argc == 3 && "--".equals(argv[optind + 1])) {
                CLI.batch(argv[optind], CLI.prepareArg(argv[optind + 2]));
                continue;
            }
            if (argc == 2) {
                CLI.batch(argv[optind], CLI.prepareArg(argv[optind + 1]));
                continue;
            }
            CLI.usage();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(CLI::cleanUpInputOrLastOutputLine));
        System.out.println(CLR);
        if (argc > 0) {
            for (String arg : argv) {
                if (optind > 0) {
                    --optind;
                    continue;
                }
                CLI.interactive(CLI.prepareArg(arg));
            }
        } else {
            CLI.repl();
        }
        System.exit(40);
    }

    private static void cleanUpInputOrLastOutputLine() {
        System.out.print("\u001b[0m\r");
        System.out.flush();
    }

    private static void repl() throws IOException {
        Console console = System.console();
        if (console != null) {
            while (true) {
                String input = CLI.prepareArg(console.readLine("%s", PROMPT));
                CLI.cleanUpInputOrLastOutputLine();
                if (input == null) {
                    return;
                }
                if ("".equals(input)) continue;
                CLI.interactive(input);
            }
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(System.in));){
            while (true) {
                String input;
                if ((input = CLI.prepareArg(r.readLine())) == null) {
                    return;
                }
                if ("".equals(input)) continue;
                CLI.interactive(input);
            }
        }
    }

    private static void interactive(String arg) {
        Path.ParserResult rmail;
        String dadr;
        String dmbx;
        String desc;
        Path asPath = lax ? UXAddress.of(arg) : Path.of(arg);
        Path.AddrSpec asAS = asPath != null ? asPath.asAddrSpec() : null;
        Path.Address asMbox = asPath != null ? asPath.forSender(false) : null;
        Path.Address asAddr = asPath != null ? asPath.forSender(true) : null;
        Path.AddressList asML = asPath != null ? asPath.asMailboxList() : null;
        Path.AddressList asAL = asPath != null ? asPath.asAddressList() : null;
        String isDom = CLI.canonicaliseParsedFQDN(FQDN.asDomain(arg));
        InetAddress i6 = IPAddress.v6(arg);
        InetAddress i4 = IPAddress.v4(arg);
        if (asMbox != null || asAddr != null || asML == null && asAL == null) {
            desc = asML == null && asAL == null ? NOLIST : ORLIST;
            dmbx = CLI.chk(asMbox);
            dadr = CLI.chk(asAddr);
            rmail = asAddr == null ? asMbox : asAddr;
        } else {
            desc = ISLIST;
            dmbx = CLI.chk(asML);
            dadr = CLI.chk(asAL);
            rmail = asAL == null ? asML : asAL;
        }
        System.out.printf("\u2023 %s\u001b[0m%n\t", MiscUtils.escapeNonPrintASCII(arg));
        System.out.printf(desc + "%n", CLI.chk(asAS), dmbx, dadr, isDom != null ? VALID : BAD, i6 == null ? BAD : VALID, i4 == null ? BAD : VALID);
        if (rmail != null && rmail.isValid()) {
            System.out.printf("\teMail: \u001b[1m%s\u001b[0m%n", rmail);
        }
        if (i6 != null || i4 != null) {
            System.out.printf("\tIP: \u001b[1m%s\u001b[0m%n", (i6 == null ? i4 : i6).getHostAddress());
        }
        if (isDom != null) {
            System.out.printf("\tFQDN: \u001b[1m%s\u001b[0m%n", isDom);
        }
        System.out.println();
    }
}

