/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import lombok.NonNull;

final class MiscUtils {
    private MiscUtils() {
    }

    static String escapeNonPrintASCII(@NonNull String s) {
        int ch;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int ofs = 0; ofs < len; ofs += Character.charCount(ch)) {
            ch = s.codePointAt(ofs);
            if (ch >= 32 && ch <= 126) {
                sb.append((char)ch);
                continue;
            }
            if (ch <= 65535) {
                sb.append(String.format("\\u%04X", ch));
                continue;
            }
            sb.append(String.format("\\U%08X", ch));
        }
        return sb.toString();
    }

    static String trim(@NonNull String s) {
        int ofs;
        int ch;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        int len = s.length();
        for (ofs = 0; ofs < len && Character.isWhitespace(ch = s.codePointAt(ofs)); ofs += Character.charCount(ch)) {
        }
        if (ofs == len) {
            return "";
        }
        int beg = ofs;
        int max = ofs;
        while (ofs < len) {
            int ch2 = s.codePointAt(ofs);
            ofs += Character.charCount(ch2);
            if (Character.isWhitespace(ch2)) continue;
            max = ofs;
        }
        return s.substring(beg, max);
    }
}

