/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.rfc822;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.evolvis.tartools.rfc822.Parser;
import org.evolvis.tartools.rfc822.Path;

public class IPAddress
extends Parser {
    public static IPAddress of(String address) {
        return Parser.of(IPAddress.class, address);
    }

    protected IPAddress(String input) {
        super(input, 64);
    }

    private InetAddress toAddress(byte[] addr) {
        if (addr == null || this.cur() != -1) {
            return null;
        }
        return InetAddress.getByAddress(this.s(), addr);
    }

    public InetAddress asIPv6Address() {
        this.jmp(0);
        return this.toAddress(this.pIPv6Address());
    }

    public InetAddress asIPv4Address() {
        this.jmp(0);
        return this.toAddress(this.pIPv4Address());
    }

    public static InetAddress v6(String address) {
        IPAddress p = IPAddress.of(address);
        return p == null ? null : p.asIPv6Address();
    }

    public static InetAddress v4(String address) {
        IPAddress p = IPAddress.of(address);
        return p == null ? null : p.asIPv4Address();
    }

    public static InetAddress from(String address) {
        IPAddress p = IPAddress.of(address);
        if (p == null) {
            return null;
        }
        InetAddress a6 = p.asIPv6Address();
        return a6 == null ? p.asIPv4Address() : a6;
    }

    private static boolean dec(int c, int limit) {
        return c >= 48 && c <= limit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] pIPv4Address() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            byte[] addr = new byte[4];
            block12: for (int a = 0; a < addr.length; ++a) {
                int v;
                if (a > 0) {
                    if (this.cur() != 46) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    this.accept();
                }
                int b1 = this.cur();
                int b2 = this.peek();
                int l2 = 57;
                int l3 = 57;
                switch (b1) {
                    case 50: {
                        l2 = 53;
                        if (b2 == 53) {
                            l3 = 53;
                        }
                    }
                    case 49: {
                        if (!IPAddress.dec(b2, l2)) break;
                        v = Character.digit(b1, 10) * 10 + Character.digit(b2, 10);
                        int b3 = this.bra(2);
                        if (IPAddress.dec(b3, l3)) {
                            v = v * 10 + Character.digit(b3, 10);
                            this.accept();
                        }
                        addr[a] = (byte)v;
                        continue block12;
                    }
                    case 48: {
                        addr[a] = 0;
                        this.accept();
                        continue block12;
                    }
                }
                if (!IPAddress.dec(b1, 57)) {
                    byte[] v2 = null;
                    return v2;
                }
                v = Character.digit(b1, 10);
                this.accept();
                if (IPAddress.dec(b2, 57)) {
                    v = v * 10 + Character.digit(b2, 10);
                    this.accept();
                }
                addr[a] = (byte)v;
            }
            byte[] byArray = ofs.accept(addr);
            return byArray;
        }
    }

    private boolean h16OrIPv4(List<Integer> dst, boolean ls32) {
        byte[] v4;
        if (!Path.is(this.cur(), (byte)-126)) {
            return true;
        }
        if (ls32 && (v4 = this.pIPv4Address()) != null) {
            dst.add(v4[0] << 8 | v4[1] & 0xFF);
            dst.add(v4[2] << 8 | v4[3] & 0xFF);
            return true;
        }
        int x = 0;
        for (int i = 0; i < 4 && Path.is(this.cur(), (byte)-126); ++i) {
            x = (x << 4) + Character.digit(this.cur(), 16);
            this.accept();
        }
        dst.add(x);
        return false;
    }

    private static byte[] rtnIPv6Address(Parser.Txn txn, List<Integer> h16s, List<Integer> afterDoubleColon) {
        if (afterDoubleColon != null) {
            int afters = afterDoubleColon.size();
            while (h16s.size() + afters < 8) {
                h16s.add(0);
            }
            h16s.addAll(afterDoubleColon);
        }
        if (h16s.size() != 8) {
            return null;
        }
        txn.commit();
        byte[] addr = new byte[16];
        for (int i = 0; i < 8; ++i) {
            int v = h16s.get(i);
            addr[i * 2] = (byte)(v >>> 8);
            addr[i * 2 + 1] = (byte)(v & 0xFF);
        }
        return addr;
    }

    protected byte[] pIPv6Address() {
        try (Parser.Txn ofs = new Parser.Txn(this);){
            ArrayList<Integer> beforeDoubleColon = new ArrayList<Integer>();
            boolean hasDoubleColon = false;
            for (int cnt = 0; cnt < 8; ++cnt) {
                if (this.cur() == 58 && this.peek() == 58) {
                    hasDoubleColon = true;
                    break;
                }
                if (cnt > 0) {
                    if (this.cur() != 58) break;
                    this.accept();
                }
                if (this.h16OrIPv4(beforeDoubleColon, cnt == 6)) break;
            }
            if (!hasDoubleColon) {
                byte[] byArray = IPAddress.rtnIPv6Address(ofs, beforeDoubleColon, null);
                return byArray;
            }
            this.accept();
            ArrayList<Integer> afterDoubleColon = new ArrayList<Integer>();
            for (int maxh16 = 7 - cnt; maxh16 > 0 && this.cur() == 58; --maxh16) {
                this.accept();
                if (this.h16OrIPv4(afterDoubleColon, maxh16 >= 2)) break;
            }
            byte[] byArray = IPAddress.rtnIPv6Address(ofs, beforeDoubleColon, afterDoubleColon);
            return byArray;
        }
    }
}

