/*
 * Decompiled with CFR 0.152.
 */
package org.evolvis.tartools.tsutc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

final class TimestampWithoutTimezoneTypeDescriptor
extends TimestampTypeDescriptor {
    private static final long serialVersionUID = -1447781774266391738L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    static final TimestampWithoutTimezoneTypeDescriptor INSTANCE = new TimestampWithoutTimezoneTypeDescriptor();

    TimestampWithoutTimezoneTypeDescriptor() {
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            private ReturnTuple internalBind(X value, WrapperOptions options) {
                ReturnTuple rv = new ReturnTuple();
                rv.timestamp = (Timestamp)javaTypeDescriptor.unwrap(value, Timestamp.class, options);
                rv.calendar = value instanceof Calendar ? (Calendar)value : Calendar.getInstance(UTC);
                return rv;
            }

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                ReturnTuple v = this.internalBind(value, options);
                st.setTimestamp(index, v.timestamp, v.calendar);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                ReturnTuple v = this.internalBind(value, options);
                st.setTimestamp(name, v.timestamp, v.calendar);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)rs.getTimestamp(name, Calendar.getInstance(UTC)), options);
            }

            protected X doExtract(CallableStatement st, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)st.getTimestamp(index, Calendar.getInstance(UTC)), options);
            }

            protected X doExtract(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)st.getTimestamp(name, Calendar.getInstance(UTC)), options);
            }
        };
    }

    private class ReturnTuple {
        Timestamp timestamp;
        Calendar calendar;

        private ReturnTuple() {
        }
    }
}

