/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.ci.utils;

import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;

public class JUnitExtra {
    public static <T extends Throwable> T assertThrowsInnermost(Class<T> expectedType, Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            Throwable cause = actualException;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (expectedType.isInstance(cause)) {
                return (T)cause;
            }
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)actualException);
            String message = "Unexpected cause exception type thrown: " + cause.getClass().getName();
            throw new AssertionFailedError(message, cause);
        }
        String message = "Expected " + expectedType.getName() + " to be thrown as cause, but nothing was thrown.";
        throw new AssertionFailedError(message);
    }
}

