/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.evrete.api.Copyable;
import org.evrete.api.EvaluationListener;
import org.evrete.api.EvaluationListeners;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.ValuesPredicate;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.CollectionUtils;

class EvaluatorStorageImpl
implements Copyable<EvaluatorStorageImpl>,
EvaluationListeners {
    private final Map<EvaluatorHandleImpl, EvaluatorWrapper> conditions = new HashMap<EvaluatorHandleImpl, EvaluatorWrapper>();
    private final Map<Evaluator, EvaluatorHandleImpl> inverse = new HashMap<Evaluator, EvaluatorHandleImpl>();
    private final LinkedHashSet<EvaluationListener> listeners = new LinkedHashSet();

    EvaluatorStorageImpl() {
    }

    private EvaluatorStorageImpl(EvaluatorStorageImpl other) {
        this.listeners.addAll(other.listeners);
        for (Map.Entry<EvaluatorHandleImpl, EvaluatorWrapper> entry : other.conditions.entrySet()) {
            EvaluatorHandleImpl h = entry.getKey();
            EvaluatorWrapper w = entry.getValue();
            this.conditions.put(h, w.copyOf());
            this.inverse.put(w.getDelegate(), h);
        }
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.listeners.add(listener);
        for (EvaluatorWrapper w : this.conditions.values()) {
            w.update(this.listeners);
        }
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.listeners.remove(listener);
        for (EvaluatorWrapper w : this.conditions.values()) {
            w.update(this.listeners);
        }
    }

    int compare(EvaluatorHandle h1, EvaluatorHandle h2) {
        EvaluatorWrapper w1 = this.get(h1, false);
        EvaluatorWrapper w2 = this.get(h2, false);
        return w1.compare(w2);
    }

    void replace(EvaluatorHandle handle, Evaluator evaluator) {
        EvaluatorWrapper existing = this.conditions.get((EvaluatorHandleImpl)handle);
        if (existing == null) {
            throw new IllegalArgumentException("Unknown evaluator handle");
        }
        if (!existing.sameDescriptor(evaluator)) {
            throw new IllegalArgumentException("Mismatched descriptors");
        }
        existing.setDelegate(evaluator);
    }

    void replace(EvaluatorHandle handle, final ValuesPredicate predicate) {
        EvaluatorWrapper existing = this.conditions.get((EvaluatorHandleImpl)handle);
        if (existing == null) {
            throw new IllegalArgumentException("Unknown evaluator handle");
        }
        final FieldReference[] newDescriptor = CollectionUtils.copyOf(existing.descriptor());
        Evaluator newEvaluator = new Evaluator(){

            @Override
            public FieldReference[] descriptor() {
                return newDescriptor;
            }

            @Override
            public boolean test(IntToValue t) {
                return predicate.test(t);
            }
        };
        existing.setDelegate(newEvaluator);
    }

    public EvaluatorWrapper get(EvaluatorHandle handle, boolean returnNull) {
        EvaluatorWrapper w = this.conditions.get((EvaluatorHandleImpl)Objects.requireNonNull(handle));
        if (w == null) {
            if (returnNull) {
                return null;
            }
            throw new IllegalArgumentException("Unknown evaluator " + handle);
        }
        return w;
    }

    public EvaluatorHandle save(Evaluator evaluator, double complexity) {
        if (complexity <= 0.0) {
            throw new IllegalArgumentException("Complexity must be positive");
        }
        if (evaluator instanceof EvaluatorWrapper) {
            throw new IllegalArgumentException();
        }
        EvaluatorHandleImpl h = this.inverse.get(evaluator);
        if (h == null) {
            h = new EvaluatorHandleImpl(evaluator, complexity);
            EvaluatorWrapper wrapper = new EvaluatorWrapper(evaluator);
            wrapper.update(this.listeners);
            this.conditions.put(h, wrapper);
            this.inverse.put(evaluator, h);
        }
        return h;
    }

    public String toString() {
        return "Evaluators{conditions=" + this.conditions + '}';
    }

    @Override
    public EvaluatorStorageImpl copyOf() {
        return new EvaluatorStorageImpl(this);
    }

    private static class EvaluatorHandleImpl
    implements EvaluatorHandle {
        private final double complexity;
        private final FieldReference[] descriptor;
        private final String asString;

        EvaluatorHandleImpl(Evaluator evaluator, double complexity) {
            this.descriptor = (FieldReference[])evaluator.descriptor().clone();
            this.complexity = complexity;
            this.asString = evaluator.toString();
        }

        @Override
        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        @Override
        public double getComplexity() {
            return this.complexity;
        }

        public String toString() {
            return this.asString;
        }
    }
}

