/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.Mask;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.async.Completer;

public class NodeDeltaTask
extends Completer {
    private static final long serialVersionUID = -9061292058914410992L;
    private final transient BetaConditionNode node;
    private final transient Collection<BetaConditionNode> sources;
    private final boolean deltaOnly;
    private final transient Mask<MemoryAddress> matchMask;

    NodeDeltaTask(Completer completer, Mask<MemoryAddress> matchMask, BetaConditionNode node, boolean deltaOnly) {
        super(completer);
        this.node = node;
        this.sources = matchMask != null ? (Collection<Object>)Arrays.stream(node.getConditionSources()).filter(n -> matchMask.intersects(n.getDescriptor().getMemoryMask())).collect(Collectors.toList()) : Arrays.asList(node.getConditionSources());
        this.deltaOnly = deltaOnly;
        this.matchMask = matchMask;
    }

    private NodeDeltaTask(NodeDeltaTask parent, BetaConditionNode node) {
        this(parent, parent.matchMask, node, parent.deltaOnly);
    }

    @Override
    protected void execute() {
        this.tailCall(this.sources, cn -> new NodeDeltaTask(this, (BetaConditionNode)cn));
    }

    @Override
    protected void onCompletion() {
        this.node.computeDelta(this.deltaOnly);
    }
}

