/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import org.evrete.Configuration;
import org.evrete.api.Knowledge;
import org.evrete.api.OrderedServiceProvider;
import org.evrete.api.StatefulSession;
import org.evrete.api.StatelessSession;
import org.evrete.api.TypeResolver;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.LiteralSourceCompiler;
import org.evrete.api.spi.MemoryFactoryProvider;
import org.evrete.api.spi.TypeResolverProvider;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.util.ForkJoinExecutor;

public class KnowledgeService {
    private final Configuration configuration;
    private final ForkJoinExecutor executor;
    private final MemoryFactoryProvider collectionsServiceProvider;
    private final ExpressionResolverProvider expressionResolverProvider;
    private final TypeResolverProvider typeResolverProvider;
    private final LiteralSourceCompiler literalSourceCompiler;
    private ClassLoader classLoader;

    public KnowledgeService(Configuration conf) {
        this(new Builder(conf));
    }

    private KnowledgeService(Builder builder) {
        this.configuration = builder.conf;
        this.executor = new ForkJoinExecutor(builder.conf.getAsInteger("evrete.core.parallelism", Runtime.getRuntime().availableProcessors()));
        this.collectionsServiceProvider = builder.getMemoryFactoryProvider();
        this.expressionResolverProvider = builder.getExpressionResolverProvider();
        this.typeResolverProvider = builder.getTypeResolverProvider();
        this.literalSourceCompiler = builder.getLiteralSourceCompiler();
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public KnowledgeService() {
        this(new Configuration());
    }

    private static Reader[] toReaders(Class<?> ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        Reader[] urls = new Reader[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            urls[i] = new StringReader(resources[i].getName());
        }
        return urls;
    }

    private static Reader[] readers(String ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        Reader[] readers = new Reader[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            readers[i] = new StringReader(resources[i]);
        }
        return readers;
    }

    public static Builder builder() {
        return new Builder(new Configuration());
    }

    public static Builder builder(Configuration configuration) {
        return new Builder(configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Knowledge newKnowledge() {
        return new KnowledgeRuntime(this);
    }

    public Knowledge newKnowledge(TypeResolver typeResolver) {
        return new KnowledgeRuntime(this, typeResolver);
    }

    public TypeResolver newTypeResolver() {
        return this.typeResolverProvider.instance(this.classLoader);
    }

    public DSLKnowledgeProvider getDSL(String dsl) {
        Objects.requireNonNull(dsl);
        ServiceLoader<DSLKnowledgeProvider> loader = ServiceLoader.load(DSLKnowledgeProvider.class);
        LinkedList<DSLKnowledgeProvider> found = new LinkedList<DSLKnowledgeProvider>();
        StringJoiner knownProviders = new StringJoiner(",", "[", "]");
        for (DSLKnowledgeProvider provider : loader) {
            String name = provider.getName();
            if (dsl.equals(name)) {
                found.add(provider);
            }
            knownProviders.add("'" + name + "' = " + provider.getClass());
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("DSL provider '" + dsl + "' is not found. Make sure the corresponding implementation is available on the classpath. Available providers: " + knownProviders);
        }
        if (found.size() > 1) {
            throw new IllegalStateException("Multiple DSL providers found implementing the '" + dsl + "' language. Known providers: " + knownProviders);
        }
        return (DSLKnowledgeProvider)found.iterator().next();
    }

    public DSLKnowledgeProvider getDSL(Class<? extends DSLKnowledgeProvider> dsl) {
        Objects.requireNonNull(dsl);
        try {
            return dsl.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate DSL class instance", e);
        }
    }

    public Knowledge newKnowledge(String dsl, URL ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, URL ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, File ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, File ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver resolver, File ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resolver, resources);
    }

    public Knowledge newKnowledge(String dsl, TypeResolver resolver, File ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resolver, resources);
    }

    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, URL ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, URL ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(String dsl, Reader ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, Reader ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, Reader ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, Reader ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(String dsl, InputStream ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, InputStream ... resources) throws IOException {
        return this.getDSL(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, InputStream ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, InputStream ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, resources);
    }

    public Knowledge newKnowledge(String dsl, Class<?> ... resources) throws IOException {
        return this.getDSL(dsl).create(this, KnowledgeService.toReaders(resources));
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public ForkJoinExecutor getExecutor() {
        return this.executor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MemoryFactoryProvider getMemoryFactoryProvider() {
        return this.collectionsServiceProvider;
    }

    public ExpressionResolverProvider getExpressionResolverProvider() {
        return this.expressionResolverProvider;
    }

    public LiteralSourceCompiler getLiteralSourceCompiler() {
        return this.literalSourceCompiler;
    }

    public TypeResolverProvider getTypeResolverProvider() {
        return this.typeResolverProvider;
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, Class<?> ... resources) throws IOException {
        return this.getDSL(dsl).create(this, KnowledgeService.toReaders(resources));
    }

    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, Class<?> ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, KnowledgeService.toReaders(resources));
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, Class<?> ... resources) throws IOException {
        return this.getDSL(dsl).create(this, typeResolver, KnowledgeService.toReaders(resources));
    }

    public StatefulSession newStatefulSession() {
        return this.newKnowledge().newStatefulSession();
    }

    public StatelessSession newStatelessSession() {
        return this.newKnowledge().newStatelessSession();
    }

    public Knowledge newKnowledge(String dsl, String ... resources) throws IOException {
        return this.getDSL(dsl).create(this, KnowledgeService.readers(resources));
    }

    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, String ... resources) throws IOException {
        return this.getDSL(dsl).create(this, KnowledgeService.readers(resources));
    }

    public static class Builder {
        private final Configuration conf;
        private Class<? extends MemoryFactoryProvider> memoryFactoryProvider;
        private Class<? extends ExpressionResolverProvider> expressionResolverProvider;
        private Class<? extends TypeResolverProvider> typeResolverProvider;
        private Class<? extends LiteralSourceCompiler> literalSourceCompiler;

        private Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder withMemoryFactoryProvider(Class<? extends MemoryFactoryProvider> memoryFactoryProvider) {
            this.memoryFactoryProvider = memoryFactoryProvider;
            return this;
        }

        public Builder withExpressionResolverProvider(Class<? extends ExpressionResolverProvider> expressionResolverProvider) {
            this.expressionResolverProvider = expressionResolverProvider;
            return this;
        }

        public Builder withTypeResolverProvider(Class<? extends TypeResolverProvider> typeResolverProvider) {
            this.typeResolverProvider = typeResolverProvider;
            return this;
        }

        public Builder withLiteralSourceCompiler(Class<? extends LiteralSourceCompiler> literalSourceCompiler) {
            this.literalSourceCompiler = literalSourceCompiler;
            return this;
        }

        public KnowledgeService build() {
            return new KnowledgeService(this);
        }

        private MemoryFactoryProvider getMemoryFactoryProvider() {
            return this.loadCoreSPI(MemoryFactoryProvider.class, "evrete.spi.memory-factory", this.memoryFactoryProvider);
        }

        private ExpressionResolverProvider getExpressionResolverProvider() {
            return this.loadCoreSPI(ExpressionResolverProvider.class, "evrete.spi.expression-resolver", this.expressionResolverProvider);
        }

        private TypeResolverProvider getTypeResolverProvider() {
            return this.loadCoreSPI(TypeResolverProvider.class, "evrete.spi.type-resolver", this.typeResolverProvider);
        }

        private LiteralSourceCompiler getLiteralSourceCompiler() {
            return this.loadCoreSPI(LiteralSourceCompiler.class, "evrete.spi.source-compiler", this.literalSourceCompiler);
        }

        private <Z extends OrderedServiceProvider, I extends Z> Z loadCoreSPI(Class<Z> clazz, String propertyName, Class<I> implClass) {
            if (implClass != null) {
                try {
                    return (Z)((OrderedServiceProvider)implClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate implementation instance of " + implClass, e);
                }
            }
            String className = this.conf.getProperty(propertyName);
            if (className != null) {
                try {
                    return (Z)((OrderedServiceProvider)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate implementation instance of " + className, e);
                }
            }
            LinkedList providers = new LinkedList();
            ServiceLoader.load(clazz).iterator().forEachRemaining(providers::add);
            Collections.sort(providers);
            if (providers.isEmpty()) {
                throw new IllegalStateException("Implementation missing: " + clazz);
            }
            return (Z)((OrderedServiceProvider)providers.iterator().next());
        }
    }
}

