/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.TypeResolver;

public interface DSLKnowledgeProvider {
    public String getName();

    default public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        return this.create(service, service.newTypeResolver(), resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, URL ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        InputStream[] streams = new InputStream[resources.length];
        try {
            for (int i = 0; i < resources.length; ++i) {
                streams[i] = resources[i].openStream();
            }
            Knowledge knowledge = this.create(service, typeResolver, streams);
            for (InputStream stream : streams) {
                stream.close();
            }
            Knowledge knowledge2 = knowledge;
            return knowledge2;
        }
        finally {
            for (InputStream stream : streams) {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    default public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        return this.create(service, service.newTypeResolver(), streams);
    }

    default public Knowledge create(KnowledgeService service, TypeResolver resolver, File ... files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return this.create(service, resolver, urls);
    }

    default public Knowledge create(KnowledgeService service, File ... files) throws IOException {
        return this.create(service, service.newTypeResolver(), files);
    }

    public Knowledge create(KnowledgeService var1, TypeResolver var2, InputStream ... var3) throws IOException;

    default public Knowledge create(KnowledgeService service, Reader ... streams) throws IOException {
        return this.create(service, service.newTypeResolver(), streams);
    }

    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, Reader ... streams) throws IOException {
        throw new UnsupportedOperationException("Method not supported by " + this.getClass().getName());
    }
}

