/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.collections.ObjIntFunction;
import org.evrete.util.CollectionUtils;

public abstract class AbstractLinearHash<E>
implements ReIterable<E> {
    private static final Logger LOGGER = Logger.getLogger(AbstractLinearHash.class.getName());
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 16;
    int size = 0;
    int deletes = 0;
    Entry[] data;
    int upperResizeBound;
    int lowerResizeBound;

    protected AbstractLinearHash() {
        this(16);
    }

    private AbstractLinearHash(int initialCapacity) {
        int capacity = AbstractLinearHash.tableSizeFor(initialCapacity);
        this.data = new Entry[capacity];
        this.setResizeBounds(capacity);
    }

    private static int findEmptyBin(int hash, int mask, Entry[] destination) {
        int pos = hash & mask;
        int counter = 0;
        while (destination[pos] != null) {
            if (counter++ == destination.length) {
                throw new IllegalStateException("Low-level implementation error, please submit a bug.");
            }
            pos = pos + 1 & mask;
        }
        return pos;
    }

    private static int tableSizeFor(int dataSize) {
        int nextPowerOfTwo = Integer.highestOneBit(dataSize);
        int cap = dataSize == nextPowerOfTwo ? dataSize : nextPowerOfTwo << 1;
        assert (cap >= dataSize);
        if (cap > 0x40000000) {
            throw new OutOfMemoryError();
        }
        return Math.max(16, cap);
    }

    private <T> Entry findBinEntry(T key, int hash, BiPredicate<E, T> eqTest) {
        Entry found;
        int size = this.data.length;
        int mask = size - 1;
        int pos = hash & mask;
        int counter = 0;
        while ((found = this.data[pos]) != null) {
            if (eqTest.test(found.cast(), key)) {
                return found;
            }
            if (counter++ == size) {
                LOGGER.warning("Low-level implementation waring, please submit a bug.");
                return null;
            }
            pos = pos + 1 & mask;
        }
        return null;
    }

    private <T> int findBinIndexForInsert(T key, int hash, BiPredicate<E, T> eqTest) {
        Entry found;
        int size = this.data.length;
        int mask = size - 1;
        int pos = hash & mask;
        int counter = 0;
        while ((found = this.data[pos]) != null && !found.deleted) {
            if (eqTest.test(found.cast(), key)) {
                return pos;
            }
            if (counter++ == size) {
                throw new IllegalStateException("Low-level implementation error, please submit a bug.");
            }
            pos = pos + 1 & mask;
        }
        return pos;
    }

    public <K> boolean computeIfAbsent(K key, BiPredicate<E, K> searchFunction, Function<K, E> producer, Consumer<E> action) {
        this.resize();
        int hash = key.hashCode();
        int binIndex = this.findBinIndexForInsert(key, hash, searchFunction);
        E existing = this.get(binIndex);
        if (existing == null) {
            this.saveDirect(producer.apply(key), hash, binIndex);
            return true;
        }
        action.accept(existing);
        return false;
    }

    public <K> E insertIfAbsent(K key, BiPredicate<E, K> searchFunction, ObjIntFunction<K, E> producer) {
        this.resize();
        int hash = key.hashCode();
        int binIndex = this.findBinIndexForInsert(key, hash, searchFunction);
        E existing = this.get(binIndex);
        if (existing == null) {
            E newValue = producer.apply(hash, key);
            this.saveDirect(newValue, hash, binIndex);
            return newValue;
        }
        return null;
    }

    public <K> E computeIfAbsent(K key, BiPredicate<E, K> searchFunction, Function<K, E> producer) {
        this.resize();
        int hash = key.hashCode();
        int binIndex = this.findBinIndexForInsert(key, hash, searchFunction);
        E result = this.get(binIndex);
        if (result == null) {
            result = producer.apply(key);
            this.saveDirect(result, hash, binIndex);
        }
        return result;
    }

    public <K> boolean remove(K key, BiPredicate<E, K> searchFunction) {
        this.resize();
        int hash = key.hashCode();
        Entry entry = this.findBinEntry(key, hash, searchFunction);
        return this.deleteEntry(entry);
    }

    public <K> boolean contains(K key, BiPredicate<E, K> searchFunction) {
        Entry found;
        int hash = key.hashCode();
        int size = this.data.length;
        int mask = size - 1;
        int pos = hash & mask;
        int counter = 0;
        while ((found = this.data[pos]) != null) {
            if (searchFunction.test(found.cast(), key)) {
                Entry entry = this.data[pos];
                return !entry.deleted;
            }
            if (counter++ == size) {
                return false;
            }
            pos = pos + 1 & mask;
        }
        return false;
    }

    public <K> E get(K key, BiPredicate<E, K> searchFunction) {
        int hash = key.hashCode();
        Entry entry = this.findBinEntry(key, hash, searchFunction);
        return this.get(entry);
    }

    private E get(int pos) {
        Entry entry = this.data[pos];
        return this.get(entry);
    }

    private E get(Entry entry) {
        return entry == null || entry.deleted ? null : (E)entry.cast();
    }

    public final <K> E add(K key, BiPredicate<E, K> equalsTest, E element) {
        this.resize();
        int hash = key.hashCode();
        int pos = this.findBinIndexForInsert(key, hash, equalsTest);
        return this.saveDirect(element, hash, pos);
    }

    private E saveDirect(E element, int hash, int pos) {
        Entry existing = this.data[pos];
        if (existing == null) {
            Entry newEntry;
            this.data[pos] = newEntry = new Entry(element, false, hash);
            ++this.size;
            return null;
        }
        if (existing.deleted) {
            existing.value = element;
            existing.hash = hash;
            existing.deleted = false;
            ++this.size;
            --this.deletes;
            return null;
        }
        Object ret = existing.cast();
        existing.value = element;
        existing.hash = hash;
        return (E)ret;
    }

    public final int size() {
        return this.size;
    }

    final void deleteEntries(Predicate<E> predicate) {
        this.forEachDataEntry((E e, int i) -> {
            if (predicate.test(e)) {
                this.deleteEntry(i);
            }
        });
        this.resize();
    }

    public void addAll(AbstractLinearHash<E> source, BinaryOperator<E> combineFunction, BiPredicate<E, E> matchFunction) {
        source.forEachInnerEntry(otherEntry -> {
            this.resize();
            int hash = otherEntry.hash;
            Object otherValue = otherEntry.cast();
            int binIndex = this.findBinIndexForInsert(otherValue, hash, matchFunction);
            Object result = combineFunction.apply(this.get(binIndex), otherValue);
            if (result == null) {
                this.deleteEntry(binIndex);
            } else {
                this.saveDirect(result, hash, binIndex);
            }
        });
    }

    void forEachInnerEntry(Consumer<Entry> consumer) {
        for (Entry o : this.data) {
            if (o == null || o.deleted) continue;
            consumer.accept(o);
        }
    }

    public void forEachDataEntry(Consumer<E> consumer) {
        for (Entry o : this.data) {
            if (o == null || o.deleted) continue;
            consumer.accept(o.cast());
        }
    }

    private void forEachDataEntry(ObjIntConsumer<E> consumer) {
        for (int idx = 0; idx < this.data.length; ++idx) {
            E obj = this.get(idx);
            if (obj == null) continue;
            consumer.accept(obj, idx);
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        this.forEachDataEntry((E k) -> joiner.add(k.toString()));
        return joiner.toString();
    }

    public void clear() {
        CollectionUtils.systemFill(this.data, null);
        this.size = 0;
    }

    private void deleteEntry(int pos) {
        Entry entry = this.data[pos];
        this.deleteEntry(entry);
    }

    private boolean deleteEntry(Entry entry) {
        if (entry == null) {
            return false;
        }
        if (entry.deleted) {
            return false;
        }
        entry.deleted = true;
        --this.size;
        ++this.deletes;
        return true;
    }

    @Override
    public ReIterator<E> iterator() {
        return new It();
    }

    public Stream<E> stream() {
        return Arrays.stream(this.data, 0, this.data.length).filter(Objects::nonNull).map(Entry::cast);
    }

    private void setResizeBounds(int tableSize) {
        this.upperResizeBound = (int)((float)tableSize * 0.75f);
        this.lowerResizeBound = (int)((float)tableSize * 0.25f);
    }

    public void resize() {
        int shrunkSize;
        int newTableSize = -1;
        if (this.size >= this.upperResizeBound) {
            newTableSize = this.data.length * 2;
        } else if (this.size <= this.lowerResizeBound && (shrunkSize = Math.max(this.data.length / 2, 16)) != this.data.length) {
            newTableSize = shrunkSize;
        }
        if (newTableSize > 0) {
            this.rebuild(newTableSize);
        }
    }

    private void rebuild(int newArrSize) {
        Entry[] newData = new Entry[newArrSize];
        int mask = newArrSize - 1;
        for (Entry o : this.data) {
            if (o == null || o.deleted) continue;
            int pos = AbstractLinearHash.findEmptyBin(o.hash, mask, newData);
            newData[pos] = o;
        }
        this.data = newData;
        this.deletes = 0;
        this.setResizeBounds(newArrSize);
    }

    static class Entry {
        Object value;
        boolean deleted;
        int hash;

        public Entry(Object value, boolean deleted, int hash) {
            this.value = value;
            this.deleted = deleted;
            this.hash = hash;
        }

        <T> T cast() {
            return (T)this.value;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "{value=" + this.value + ", del=" + this.deleted + ", hash=" + this.hash + '}';
        }
    }

    private final class It
    implements ReIterator<E> {
        int pos = 0;
        int nextIndex = this.computeNextIndex();
        int currentIndex = -1;

        private It() {
        }

        @Override
        public long reset() {
            this.pos = 0;
            this.nextIndex = this.computeNextIndex();
            return AbstractLinearHash.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private int computeNextIndex() {
            while (this.pos < AbstractLinearHash.this.data.length) {
                Entry entry = AbstractLinearHash.this.data[this.pos];
                if (entry == null || entry.deleted) {
                    ++this.pos;
                    continue;
                }
                return this.pos;
            }
            return -1;
        }

        @Override
        public E next() {
            if (this.nextIndex < 0) {
                throw new NoSuchElementException();
            }
            ++this.pos;
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.computeNextIndex();
            return AbstractLinearHash.this.data[this.currentIndex].cast();
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new NoSuchElementException();
            }
            AbstractLinearHash.this.deleteEntry(AbstractLinearHash.this.data[this.currentIndex]);
        }
    }
}

