/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Objects;
import org.evrete.api.ReIterator;
import org.evrete.util.CollectionUtils;

public final class JoinReIterator<V>
implements ReIterator<V> {
    private final ReIterator<V>[] iterators;
    private ReIterator<V> current;
    private int currentIndex;

    private JoinReIterator(ReIterator<V>[] iterators) {
        this.iterators = iterators;
        this.currentIndex = 0;
        this.current = iterators[0];
    }

    @SafeVarargs
    public static <V, Z extends ReIterator<V>> ReIterator<V> of(Z ... iterators) {
        Objects.requireNonNull(iterators);
        return iterators.length == 0 ? CollectionUtils.emptyReIterator() : new JoinReIterator<V>((ReIterator<V>[])iterators);
    }

    @Override
    public long reset() {
        long size = 0L;
        for (ReIterator<V> it : this.iterators) {
            size += it.reset();
        }
        this.currentIndex = 0;
        this.current = this.iterators[this.currentIndex];
        return size;
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    @Override
    public boolean hasNext() {
        if (this.current.hasNext()) {
            return true;
        }
        if (++this.currentIndex == this.iterators.length) {
            return false;
        }
        this.current = this.iterators[this.currentIndex];
        return this.hasNext();
    }

    @Override
    public V next() {
        return (V)this.current.next();
    }
}

