/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.NoSuchElementException;
import java.util.StringJoiner;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;

public class LinkedDataRWD<T>
implements ReIterable<T> {
    private long size;
    private Node<T> firstNode;
    private Node<T> lastNode;

    public LinkedDataRWD<T> add(T object) {
        Node<T> newLastNode;
        if (this.lastNode == null) {
            newLastNode = new Node<T>(object, null);
            this.firstNode = newLastNode;
        } else {
            Node<T> oldLastNode = this.lastNode;
            newLastNode = new Node<T>(object, oldLastNode);
            oldLastNode.next = newLastNode;
            newLastNode.prev = oldLastNode;
        }
        this.lastNode = newLastNode;
        this.updateSize(1L);
        return this;
    }

    private void updateSize(long delta) {
        this.size += delta;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        this.iterator().forEachRemaining(t -> sj.add(t == null ? "null" : t.toString()));
        return sj.toString();
    }

    public void consume(LinkedDataRWD<T> other) {
        if (other.lastNode != null) {
            if (this.lastNode == null) {
                this.lastNode = other.lastNode;
                this.firstNode = other.firstNode;
                this.size = other.size;
            } else {
                Node<T> myOldLastNode = this.lastNode;
                this.lastNode = other.lastNode;
                myOldLastNode.next = other.firstNode;
                other.firstNode.prev = myOldLastNode;
                this.size += other.size;
            }
            other.clear();
        }
    }

    public long size() {
        return this.size;
    }

    Node<T> first() {
        return this.firstNode;
    }

    Node<T> last() {
        return this.lastNode;
    }

    private void setFirst(Node<T> node) {
        this.firstNode = node;
        if (node == null) {
            this.lastNode = null;
            this.size = 0L;
        } else {
            this.firstNode.prev = null;
        }
    }

    private void setLast(Node<T> node) {
        this.lastNode = node;
        if (node == null) {
            this.firstNode = null;
            this.size = 0L;
        } else {
            this.lastNode.next = null;
        }
    }

    public void clear() {
        this.firstNode = null;
        this.lastNode = null;
        this.size = 0L;
    }

    private void removeNode(Node<T> node) {
        this.updateSize(-1L);
        if (node.prev == null) {
            this.setFirst(node.next);
            node.clearRefs();
        } else if (node.next == null) {
            this.setLast(node.prev);
            node.clearRefs();
        } else {
            node.drop();
        }
    }

    @Override
    public ReIterator<T> iterator() {
        return new It();
    }

    static class Node<Z> {
        final Z data;
        Node<Z> prev;
        Node<Z> next;

        Node(Z data, Node<Z> prev) {
            this.data = data;
            this.prev = prev;
        }

        void drop() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.clearRefs();
        }

        void clearRefs() {
            this.next = null;
            this.prev = null;
        }
    }

    private class It
    implements ReIterator<T> {
        Node<T> next;
        Node<T> last;

        It() {
            this.next = LinkedDataRWD.this.firstNode;
        }

        @Override
        public long reset() {
            this.next = LinkedDataRWD.this.firstNode;
            this.last = null;
            return LinkedDataRWD.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.last.next;
            return this.last.data;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator: remove() without next()");
            }
            LinkedDataRWD.this.removeNode(this.last);
        }
    }
}

